--
--   Uninstallation script for "Schema Version Control for Oracle" (SVCO)
--   http://www.sumsoftsolutions.com
--
--   File Name: uninstall.sql
--   SVCO Version: 3.0.0
--   DB: Oracle 11g and later
--   OS: non-specific
--   Comments: For details please see readme.txt
--

SET SERVEROUTPUT ON SIZE UNLIMITED
SET PAGESIZE 0
SET VERIFY OFF
WHENEVER OSERROR EXIT
WHENEVER SQLERROR EXIT

PROMPT ...............................................................
PROMPT ... Uninstalling "Schema Version Control for Oracle" (SVCO) ...
PROMPT ...          http://www.sumsoftsolutions.com                ...
PROMPT ...............................................................
PROMPT
PROMPT ... Checking uninstallation requirements ......................

-- Check block
begin
	if  sys_context('USERENV', 'ISDBA') <> 'TRUE' then
		RAISE_APPLICATION_ERROR(-20700, '!!! Please login AS SYSDBA !!!');
	end if;	
	if upper(sys_context('USERENV', 'SESSION_USER')) <> 'SYS' then
		RAISE_APPLICATION_ERROR(-20700, '!!! Please login as SYS user !!!');
	end if;
end;
/
PROMPT ... Done ......................................................
PROMPT
PAUSE THIS SCRIPT WILL DROP SVCO REPOSITORY. ARE YOU SURE? PRESS RETURN TO CONTINUE 
PROMPT
PROMPT ... Uninstalling ..............................................
declare
	v_count number;
begin
	select count(1)
	into v_count
	from dba_roles
	where role = 'SVCO_REP_OPERATOR';
	if v_count > 0 then  EXECUTE IMMEDIATE 'DROP ROLE SVCO_REP_OPERATOR';
	end if;
	select count(1)
	into v_count
	from dba_roles
	where role = 'SVCO_REP_ADMIN';
	if v_count > 0 then  EXECUTE IMMEDIATE 'DROP ROLE SVCO_REP_ADMIN';
	end if;
	select count(1)
	into v_count
	from dba_users
	where username = 'SVCO';
	if v_count > 0 then 
	 begin
	 	begin
	 		EXECUTE IMMEDIATE 'BEGIN SVCO.VCONTROL_ADMIN.STOP_VERSION_CONTROL; END;';
	 	exception
	 		when others then null;	
	 	end;	
	 	EXECUTE IMMEDIATE 'DROP USER SVCO CASCADE';
	 end;	
	end if;	
	select count(1)
	into v_count
	from dba_objects
	where owner = 'SYS' and object_name = 'DBMS_METADATA_DVCO' and object_type = 'PACKAGE';
	if v_count > 0 then  EXECUTE IMMEDIATE 'DROP PACKAGE DBMS_METADATA_DVCO';
	end if;	
end;
/
PROMPT ... Done ......................................................
PROMPT
PROMPT ... All done ...
PROMPT
exit
