CREATE OR REPLACE VIEW SVCO.V_IGNORE_OBJECTS
(
    SCHEMA,
    OBJECT_NAME
)
AS
select t.schema, t.obj_name object_name
  from t_ignore_objects t
 where (vcontrol.Has_Admin_Role = 1 or
       upper(sys_context('USERENV', 'SESSION_USER')) = t.schema)
/
----------------------------------------------------
CREATE OR REPLACE VIEW SVCO.V_INCLUDE_OBJECTS
(
    SCHEMA,
    OBJECT_NAME
)
AS
select t.schema, t.obj_name object_name
  from t_include_objects t
 where (vcontrol.Has_Admin_Role = 1 or
       upper(sys_context('USERENV', 'SESSION_USER')) = t.schema)
/
----------------------------------------------------
CREATE OR REPLACE VIEW SVCO.V_OBJECT
(
    SCHEMA,
    OBJECT,
    OBJECT_TYPE,
    DEPENDENT_SCHEMA,
    DEPENDENT_OBJECT,
    DEPENDENT_OBJECT_TYPE
)
AS
select t1.schema
      ,t1.name object
      ,t1.obj_type object_type
      ,t2.schema dependent_schema
      ,t2.name dependent_object
      ,t2.obj_type dependent_object_type
  from t_object t1, t_object t2
 where t1.depends_obj_id = t2.obj_id(+)
   and (vcontrol.Has_Admin_Role = 1 or
       upper(sys_context('USERENV', 'SESSION_USER')) = t1.schema)
/       
----------------------------------------------------
CREATE OR REPLACE VIEW SVCO.V_OBJECT_DROPPED
(
    DROPPED_OBJECT_ID,
    SCHEMA,
    OBJECT,
    OBJECT_TYPE,
    DB_USER,
    OS_USER,
    MACHINE,
    DROPPED_TIME,
    IP_ADDRESS,
    MODULE,
    DEPENDENT_OBJECT_ID,
    DEPENDENT_SCHEMA,
    DEPENDENT_OBJECT,
    DEPENDENT_OBJECT_TYPE
)
AS
select t1.obj_id dropped_object_id
      ,t1.schema
      ,t1.name object
      ,t1.obj_type object_type
      ,t1.dbuser db_user
      ,t1.osuser os_user
      ,t1.machine
      ,t1.dropped_time
      ,t1.ip_address
      ,t1.module
      ,t2.obj_id dependent_object_id
      ,t2.schema dependent_schema
      ,t2.name dependent_object
      ,t2.obj_type dependent_object_type
  from t_object_dropped t1, t_object_dropped t2
 where t1.depends_obj_id = t2.obj_id(+)
   and (vcontrol.Has_Admin_Role = 1 or
       upper(sys_context('USERENV', 'SESSION_USER')) = t1.schema)
/
----------------------------------------------------
CREATE OR REPLACE VIEW SVCO.V_OBJECT_VERSION
(
    SCHEMA,
    OBJECT,
    OBJECT_TYPE,
    VERSION_ID,
    DB_USER,
    OS_USER,
    MACHINE,
    DDL_TIME,
    IP_ADDRESS,
    MODULE
)
AS
select t.schema
      ,t.name object
      ,t.obj_type object_type
      ,v.version_id
      ,v.dbuser db_user
      ,v.osuser os_user
      ,v.machine
      ,v.ddl_time
      ,v.ip_address
      ,v.module
  from t_object t, t_object_version v
 where t.obj_id = v.obj_id(+)
   and (vcontrol.Has_Admin_Role = 1 or
       upper(sys_context('USERENV', 'SESSION_USER')) = t.schema)
/
----------------------------------------------------
CREATE OR REPLACE VIEW SVCO.V_OBJECT_VERSION_DROPPED
(
    DROPPED_OBJECT_ID,
    SCHEMA,
    OBJECT,
    OBJECT_TYPE,
    VERSION_ID,
    DB_USER,
    OS_USER,
    MACHINE,
    DDL_TIME,
    IP_ADDRESS,
    MODULE
)
AS
select t.obj_id dropped_object_id
      ,t.schema
      ,t.name object
      ,t.obj_type object_type
      ,v.version_id
      ,v.dbuser db_user
      ,v.osuser os_user
      ,v.machine
      ,v.ddl_time
      ,v.ip_address
      ,v.module
  from t_object_dropped t, t_object_version_dropped v
 where t.obj_id = v.obj_id(+)
   and (vcontrol.Has_Admin_Role = 1 or
       upper(sys_context('USERENV', 'SESSION_USER')) = t.schema)
/
----------------------------------------------------
