create or replace trigger SVCO.tr_after_ddl_database
after DDL ON database
 /*
  * "Schema Version Control for Oracle" (SVCO)
  *      http://www.sumsoftsolutions.com
  * PLEASE READ LICENSE AGREEMENT CAREFULLY BEFORE USING THIS SOFTWARE
  *
  */
declare
  sql_text ora_name_list_t;
  c4k CONSTANT BINARY_INTEGER := 4000;
  stmt VARCHAR2(4000) := '';
  n    BINARY_INTEGER;
begin
  if vcontrol_util.Debug = 1 then
    begin
      n := ora_sql_txt(sql_text);
      FOR i IN 1 .. n LOOP
        stmt := substr(stmt || sql_text(i), 1, c4k);
        EXIT WHEN length(stmt) = c4k;
      END LOOP;
    end;
  end if;

  vcontrol_int.after_ddl_database(ddl_change_msg_typ(ora_login_user
                                                    ,ora_dict_obj_owner
                                                    ,ora_dict_obj_name
                                                    ,ora_dict_obj_type
                                                    ,ora_sysevent
                                                    ,stmt
                                                    ,sys_context('USERENV'
                                                                ,'OS_USER')
                                                    ,sys_context('USERENV'
                                                                ,'HOST')
                                                    ,sys_context('USERENV'
                                                                ,'IP_ADDRESS')
                                                    ,sys_context('USERENV'
                                                                ,'MODULE')));
END;
/
ALTER TRIGGER SVCO.TR_AFTER_DDL_DATABASE DISABLE
/
----------------------------------------------------
create or replace trigger SVCO.tr_before_insert_v_ignore_obj
instead of insert ON SVCO.v_ignore_objects
 referencing new as new
  /*
  * "Schema Version Control for Oracle" (SVCO)
  *      http://www.sumsoftsolutions.com
  * PLEASE READ LICENSE AGREEMENT CAREFULLY BEFORE USING THIS SOFTWARE
  *
  */
begin
  if upper(sys_context('USERENV', 'SESSION_USER')) <> upper(:new.schema)
     and vcontrol.Has_Admin_Role <> 1 then
    RAISE_APPLICATION_ERROR(exceptions_.en_no_rights
                           ,'You do not have enough rights to insert not own objects');
  else
    insert into t_ignore_objects
      (schema, obj_name)
    values
      (upper(:new.schema), :new.object_name);
  end if;
end;
/
----------------------------------------------------
create or replace trigger SVCO.tr_before_insert_v_include_obj
instead of insert ON SVCO.v_include_objects
 referencing new as new
 /*
  * "Schema Version Control for Oracle" (SVCO)
  *      http://www.sumsoftsolutions.com
  * PLEASE READ LICENSE AGREEMENT CAREFULLY BEFORE USING THIS SOFTWARE
  *
  */ 
begin
  if upper(sys_context('USERENV', 'SESSION_USER')) <> upper(:new.schema)
     and vcontrol.Has_Admin_Role <> 1 then
    RAISE_APPLICATION_ERROR(exceptions_.en_no_rights
                           ,'You do not have enough rights to insert not own objects');
  else
    insert into t_include_objects
      (schema, obj_name)
    values
      (upper(:new.schema), :new.object_name);
  end if;
end;
/
