CREATE TABLE SVCO.T_TAG
(
    TAG_ID         NUMBER               NOT NULL,
    NAME           VARCHAR2(30 BYTE)    NOT NULL,
    COMMENTS       VARCHAR2(4000 CHAR)  NULL,
    CREATED_AT     DATE                 DEFAULT SYSDATE NOT NULL
)
TABLESPACE &tabtbs
/
ALTER TABLE SVCO.T_TAG
    ADD CONSTRAINT T_TAG_PK
    PRIMARY KEY (TAG_ID)
    USING INDEX TABLESPACE &idxtbs
    ENABLE
/
ALTER TABLE SVCO.T_TAG
    ADD CONSTRAINT T_TAG_UNQ_I
    UNIQUE (NAME)
    USING INDEX TABLESPACE &idxtbs
    ENABLE
/
----------------------------------------------------
CREATE TABLE SVCO.T_TAG_TO_OBJECT_VERSION
(
    TAG_ID     NUMBER       NOT NULL,
    OBJ_ID     NUMBER       NOT NULL,
    VERSION_ID NUMBER       NOT NULL,
    TAGGED_AT  DATE         DEFAULT SYSDATE NOT NULL
)
TABLESPACE &tabtbs
/
ALTER TABLE SVCO.T_TAG_TO_OBJECT_VERSION
    ADD CONSTRAINT T_TAG_TO_OBJECT_VERSION_PK
    PRIMARY KEY (TAG_ID, OBJ_ID)
    USING INDEX TABLESPACE &idxtbs
    ENABLE
/
ALTER TABLE SVCO.T_TAG_TO_OBJECT_VERSION
    ADD CONSTRAINT T_TAG_TO_OBJECT_VERSION_TAG_FK
    FOREIGN KEY (TAG_ID)
    REFERENCES SVCO.T_TAG (TAG_ID)
    ON DELETE CASCADE
    ENABLE
/
ALTER TABLE SVCO.T_TAG_TO_OBJECT_VERSION
    ADD CONSTRAINT T_TAG_TO_OBJECT_VERSION_OBJ_FK
    FOREIGN KEY (OBJ_ID, VERSION_ID)
    REFERENCES SVCO.T_OBJECT_VERSION (OBJ_ID, VERSION_ID)
    ON DELETE CASCADE
    ENABLE
/
