CREATE OR REPLACE PACKAGE SVCO.exceptions_
IS
  /*
  * "Schema Version Control for Oracle" (SVCO)
  *      http://www.sumsoftsolutions.com
  * PLEASE READ LICENSE AGREEMENT CAREFULLY BEFORE USING THIS SOFTWARE
  *
  * PURPOSE
  * This package defines custom exceptions.
  *
  * SECURITY
  * This package is granted to SVCO_REP_OPERATOR and SVCO_REP_ADMIN roles.
  */
  --
  -- DESCRIPTION
  -- Thrown when something unusual is happened.
  -- More details will be provided in exception message text.
  --
  en_unhandled  CONSTANT NUMBER := -20700;
  exc_unhandled EXCEPTION;
  PRAGMA EXCEPTION_INIT(exc_unhandled, -20700);
  --
  -- DESCRIPTION
  -- Thrown when something not found.
  -- More details will be provided in exception message text.
  --
  en_no_data_found  CONSTANT NUMBER := -20701;
  exc_no_data_found EXCEPTION;
  PRAGMA EXCEPTION_INIT(exc_no_data_found, -20701);
  --
  -- DESCRIPTION
  -- Thrown when caller has not enough privileges to complete this operation.
  -- More details will be provided in exception message text.
  --
  en_no_rights  CONSTANT NUMBER := -20702;
  exc_no_rights EXCEPTION;
  PRAGMA EXCEPTION_INIT(exc_no_rights, -20702);
  --
  -- DESCRIPTION
  -- Thrown when more than one record found.
  -- More details will be provided in exception message text.
  --
  en_too_many_rows  CONSTANT NUMBER := -20703;
  exc_too_many_rows EXCEPTION;
  PRAGMA EXCEPTION_INIT(exc_too_many_rows, -20703);
  --
  -- DESCRIPTION
  -- Thrown when not all required parameters are specified.
  -- More details will be provided in exception message text.
  --
  en_req_param  CONSTANT NUMBER := -20704;
  exc_req_param EXCEPTION;
  PRAGMA EXCEPTION_INIT(exc_req_param, -20704);
  --
  -- DESCRIPTION
  -- Thrown when a new program version is available.
  -- More details will be provided in exception message text.
  --
  en_update_chk  CONSTANT NUMBER := -20705;
  exc_update_chk EXCEPTION;
  PRAGMA EXCEPTION_INIT(exc_update_chk, -20705);
END exceptions_;
/
