/*
 * Decompiled with CFR 0.152.
 */
package quick.dbtable;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Vector;

class QuickVector
implements Cloneable,
Serializable {
    private transient Object[] elementData;
    private int size;

    QuickVector(int initialCapacity) {
        this.elementData = new Object[initialCapacity];
    }

    QuickVector() {
        this(10);
    }

    QuickVector(Vector c) {
        this.copyVector(c);
    }

    QuickVector(Object[] c, boolean convertArrayOfArray) {
        if (convertArrayOfArray) {
            this.size = 0;
            this.elementData = new Object[c.length];
            int i = 0;
            while (i < c.length) {
                QuickVector q = new QuickVector((Object[])c[i], false);
                this.addElement(q);
                ++i;
            }
        } else {
            this.size = c.length;
            this.elementData = (Object[])c.clone();
        }
    }

    QuickVector(Vector c, boolean convertVectorOfVector) {
        if (convertVectorOfVector) {
            this.size = 0;
            this.elementData = new Object[c.size()];
            int firstRowSize = 0;
            int i = 0;
            while (i < c.size()) {
                QuickVector q = new QuickVector((Vector)c.elementAt(i));
                if (i == 0) {
                    firstRowSize = q.size();
                }
                if (i > 0 && firstRowSize != q.size()) {
                    System.out.println("Number of columns in row " + (i + 1) + " is " + q.size() + ",but total columns is " + firstRowSize + ". Row not loaded");
                } else {
                    this.addElement(q);
                }
                ++i;
            }
        } else {
            this.copyVector(c);
        }
    }

    private void copyVector(Vector c) {
        this.size = c.size();
        this.elementData = new Object[this.size];
        c.copyInto(this.elementData);
    }

    public void removeAllElements() {
        this.clear();
    }

    public void setElementAt(Object obj, int index) {
        this.set(index, obj);
    }

    public void removeElementAt(int index) {
        this.remove(index);
    }

    public void addElement(Object obj) {
        this.add(obj);
    }

    public Object elementAt(int index) {
        return this.get(index);
    }

    public boolean removeElement(Object obj) {
        int i = this.indexOf(obj);
        if (i >= 0) {
            this.remove(i);
            return true;
        }
        return false;
    }

    public void insertElementAt(Object obj, int index) {
        if (index >= this.size + 1) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " > " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.size - index);
        this.elementData[index] = obj;
        ++this.size;
    }

    public void trimToSize() {
        int oldCapacity = this.elementData.length;
        if (this.size < oldCapacity) {
            Object[] oldData = this.elementData;
            this.elementData = new Object[this.size];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            Object[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new Object[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(Object elem) {
        return this.indexOf(elem) >= 0;
    }

    public int indexOf(Object elem) {
        if (elem == null) {
            int i = 0;
            while (i < this.size) {
                if (this.elementData[i] == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size) {
                if (elem.equals(this.elementData[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object elem) {
        if (elem == null) {
            int i = this.size - 1;
            while (i >= 0) {
                if (this.elementData[i] == null) {
                    return i;
                }
                --i;
            }
        } else {
            int i = this.size - 1;
            while (i >= 0) {
                if (elem.equals(this.elementData[i])) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            QuickVector v = (QuickVector)super.clone();
            v.elementData = new Object[this.size];
            System.arraycopy(this.elementData, 0, v.elementData, 0, this.size);
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Vector getVector() {
        TempVector v = new TempVector();
        v.initialize();
        return v;
    }

    public Object[] toArray() {
        Object[] result = new Object[this.size];
        System.arraycopy(this.elementData, 0, result, 0, this.size);
        return result;
    }

    public Object[] toArray(Object[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.elementData, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    public void copyInto(Object[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.elementData, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
    }

    public Object get(int index) {
        this.RangeCheck(index);
        return this.elementData[index];
    }

    public Object set(int index, Object element) {
        this.RangeCheck(index);
        Object oldValue = this.elementData[index];
        this.elementData[index] = element;
        return oldValue;
    }

    public boolean add(Object o) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = o;
        return true;
    }

    public void add(int index, Object element) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.size - index);
        this.elementData[index] = element;
        ++this.size;
    }

    public Object remove(int index) {
        this.RangeCheck(index);
        Object oldValue = this.elementData[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        this.elementData[--this.size] = null;
        return oldValue;
    }

    public void clear() {
        int i = 0;
        while (i < this.size) {
            this.elementData[i] = null;
            ++i;
        }
        this.size = 0;
    }

    protected void removeRange(int fromIndex, int toIndex) {
        int numMoved = this.size - toIndex;
        System.arraycopy(this.elementData, toIndex, this.elementData, fromIndex, numMoved);
        int newSize = this.size - (toIndex - fromIndex);
        while (this.size != newSize) {
            this.elementData[--this.size] = null;
        }
    }

    private void RangeCheck(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.elementData.length);
        int i = 0;
        while (i < this.size) {
            s.writeObject(this.elementData[i]);
            ++i;
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int arrayLength = s.readInt();
        this.elementData = new Object[arrayLength];
        int i = 0;
        while (i < this.size) {
            this.elementData[i] = s.readObject();
            ++i;
        }
    }

    class TempVector
    extends Vector {
        TempVector() {
        }

        public void initialize() {
            this.elementData = new Object[QuickVector.this.size];
            this.elementCount = QuickVector.this.size;
            System.arraycopy(QuickVector.this.elementData, 0, this.elementData, 0, QuickVector.this.size);
        }
    }
}

