/*
 * Decompiled with CFR 0.152.
 */
package quick.dbtable;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import quick.dbtable.DBTableColumnModel;
import quick.dbtable.PrintProperties;

class PrintableTable {
    private int[] subTableSplit = null;
    private int prevPageIndex = 0;
    private int subPageIndex = 0;
    private int subTableSplitSize = 0;
    private double tableHeightOnFullPage;
    private double headerHeight;
    private int headerFontHeight;
    private int headerFontDesent;
    private int headerFontAscent;
    private int footerFontHeight;
    private int footerFontDesent;
    private int footerFontAscent;
    private double tableHeight;
    private double rowHeight;
    private JTableHeader tableHeader;
    private JTable source;
    private int pageHieght = 648;
    private int pageWidth = 468;
    private boolean pageInfoCalculated = false;
    private int totalNumPages = -1;
    static final int PAGE_EXISTS = 0;
    static final int NO_SUCH_PAGE = 1;
    private int[] oldSelection;
    private PrintProperties prop;
    private Vector headerVector;
    private Vector footerVector;
    private String sPageNumber = "%1%";
    private String sSubPageNumber = "%2%";

    PrintableTable(JTable table) {
        this(table, new PrintProperties());
    }

    PrintableTable(JTable table, PrintProperties prop) {
        this.source = table;
        this.prop = prop;
        this.headerVector = this.createVector(prop.getHeader());
        this.footerVector = this.createVector(prop.getFooter());
        this.pageWidth = prop.getPaperWidth() - 2 * prop.getBorderWidth();
        this.pageHieght = prop.getPaperHeight() - 2 * prop.getBorderHeight();
    }

    PrintProperties getPrintProperties() {
        return this.prop;
    }

    private Vector createVector(String in) {
        Vector<String> v = new Vector<String>();
        if (in == null) {
            return v;
        }
        try {
            LineNumberReader ln = new LineNumberReader(new StringReader(in));
            String val = null;
            while ((val = ln.readLine()) != null) {
                v.addElement(val);
            }
        }
        catch (Exception e) {
            System.out.println("Error while parsing print header or footer " + e.getMessage());
        }
        return v;
    }

    private void clearSelection() {
        if (this.source.isEditing()) {
            this.source.editingStopped(new ChangeEvent(this.source));
        }
        this.oldSelection = this.source.getSelectedRows();
        this.source.clearSelection();
    }

    private void addSelection() {
        int i = 0;
        while (i < this.oldSelection.length) {
            this.source.addRowSelectionInterval(this.oldSelection[i], this.oldSelection[i]);
            ++i;
        }
    }

    void getPageInfo(Graphics g) {
        this.subTableSplit = null;
        this.subTableSplitSize = 0;
        this.subPageIndex = 0;
        this.prevPageIndex = 0;
        g.setFont(this.prop.getHeaderFont());
        this.headerFontHeight = g.getFontMetrics().getHeight();
        this.headerFontDesent = g.getFontMetrics().getDescent();
        this.headerFontAscent = g.getFontMetrics().getAscent();
        g.setFont(this.prop.getHeaderFont());
        this.footerFontHeight = g.getFontMetrics().getHeight();
        this.footerFontDesent = g.getFontMetrics().getDescent();
        this.footerFontAscent = g.getFontMetrics().getAscent();
        g.setFont(this.source.getFont());
        int columns = 0;
        int columnMargin = 0;
        double headerWidth = 0.0;
        this.headerHeight = 0.0;
        if (this.prop.printTableHeader()) {
            this.tableHeader = this.source.getTableHeader();
            headerWidth = this.tableHeader.getWidth();
            this.headerHeight = this.tableHeader.getHeight() + this.source.getIntercellSpacing().height;
        }
        double tableWidth = this.source.getColumnModel().getTotalColumnWidth();
        this.tableHeight = this.source.getHeight();
        this.rowHeight = this.source.getRowHeight() + this.source.getIntercellSpacing().height;
        this.tableHeightOnFullPage = (int)((double)this.pageHieght - this.headerHeight - (double)(this.headerFontHeight * this.headerVector.size() + this.footerFontHeight * this.footerVector.size()));
        this.tableHeightOnFullPage = this.tableHeightOnFullPage / this.rowHeight * this.rowHeight + 1.0;
        TableColumnModel tableColumnModel = this.source.getColumnModel();
        columns = tableColumnModel.getColumnCount();
        columnMargin = tableColumnModel.getColumnMargin();
        int[] temp = new int[columns];
        int columnIndex = 0;
        temp[0] = 0;
        int columnWidth = 0;
        int length = 0;
        this.subTableSplitSize = 0;
        while (columnIndex < columns) {
            Rectangle r = null;
            try {
                r = this.source.getCellRect(0, columnIndex, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            columnWidth = r != null ? r.width : (tableColumnModel instanceof DBTableColumnModel ? ((DBTableColumnModel)tableColumnModel).getColumnAsCreated(columnIndex).getWidth() : tableColumnModel.getColumn(columnIndex).getWidth());
            if (length + columnWidth + columnMargin > this.pageWidth) {
                if (length > 0) {
                    temp[this.subTableSplitSize + 1] = temp[this.subTableSplitSize] + length;
                    ++this.subTableSplitSize;
                }
                length = columnWidth + columnMargin;
            } else {
                length += columnWidth + columnMargin;
            }
            ++columnIndex;
        }
        if (length > 0) {
            if (this.subTableSplitSize < temp.length - 1) {
                temp[this.subTableSplitSize + 1] = temp[this.subTableSplitSize] + length;
                ++this.subTableSplitSize;
            } else {
                int[] temp1 = new int[this.subTableSplitSize + 2];
                int i = 0;
                while (i < temp.length) {
                    temp1[i] = temp[i];
                    ++i;
                }
                temp1[this.subTableSplitSize + 1] = temp[this.subTableSplitSize] + length;
                ++this.subTableSplitSize;
                temp = temp1;
            }
        }
        ++this.subTableSplitSize;
        this.subTableSplit = new int[this.subTableSplitSize];
        int i = 0;
        while (i < this.subTableSplitSize) {
            this.subTableSplit[i] = temp[i];
            ++i;
        }
        this.totalNumPages = (int)Math.ceil(this.tableHeight / this.tableHeightOnFullPage);
        if (this.totalNumPages == 0) {
            ++this.totalNumPages;
        }
        this.totalNumPages *= this.subTableSplitSize - 1;
    }

    int printPage(Graphics g2, int pageIndex) {
        if (!this.pageInfoCalculated) {
            this.getPageInfo(g2);
            this.pageInfoCalculated = true;
        }
        if (pageIndex >= this.totalNumPages) {
            return 1;
        }
        if (this.prevPageIndex != pageIndex) {
            if (pageIndex > this.prevPageIndex) {
                ++this.subPageIndex;
                if (this.subPageIndex == this.subTableSplitSize - 1) {
                    this.subPageIndex = 0;
                }
            } else if (pageIndex < this.prevPageIndex) {
                --this.subPageIndex;
                if (this.subPageIndex == -1) {
                    this.subPageIndex = this.subTableSplitSize - 2;
                }
            }
        }
        int rowIndex = pageIndex / (this.subTableSplitSize - 1);
        int columnIndex = this.subPageIndex;
        this.prevPageIndex = pageIndex;
        g2.translate(this.prop.getBorderWidth(), this.prop.getBorderHeight());
        int pageLeft = this.subTableSplit[columnIndex];
        int pageRight = this.subTableSplit[columnIndex + 1];
        int pageWidth = pageRight - pageLeft + 1;
        this.drawText(this.headerFontAscent, this.headerVector, g2, this.prop.getHeaderAlign(), true, rowIndex + 1, columnIndex + 1);
        this.drawText(this.pageHieght - this.footerFontDesent, this.footerVector, g2, this.prop.getFooterAlign(), false, rowIndex + 1, columnIndex + 1);
        g2.setFont(this.source.getFont());
        g2.setColor(Color.black);
        double clipHeight = Math.min(this.tableHeightOnFullPage, this.tableHeight - (double)rowIndex * this.tableHeightOnFullPage);
        g2.translate(0, this.headerFontHeight * this.headerVector.size());
        g2.translate(-this.subTableSplit[columnIndex], 0);
        if (this.prop.printTableHeader()) {
            g2.setClip(pageLeft, 0, pageWidth, (int)this.headerHeight);
            this.tableHeader.paint(g2);
            g2.translate(0, (int)this.headerHeight);
        }
        g2.translate(0, (int)(-this.tableHeightOnFullPage) * rowIndex);
        this.clearSelection();
        g2.setClip(pageLeft, (int)this.tableHeightOnFullPage * rowIndex, pageWidth, (int)clipHeight);
        ((Component)this.source).paint(g2);
        this.addSelection();
        double pageTop = this.tableHeightOnFullPage * (double)rowIndex - this.headerHeight;
        double pageBottom = pageTop + clipHeight + this.headerHeight;
        if (this.prop.printBorder()) {
            g2.drawRect(pageLeft, (int)pageTop, pageWidth, (int)(clipHeight + this.headerHeight));
        }
        return 0;
    }

    private void drawText(int y, Vector input, Graphics g, int align, boolean topToBottom, int page, int subPage) {
        if (input.size() == 0) {
            return;
        }
        int i = 0;
        int vertical = y;
        if (!topToBottom) {
            i = input.size() - 1;
        }
        if (topToBottom) {
            g.setFont(this.prop.getHeaderFont());
            g.setColor(this.prop.getHeaderColor());
        } else {
            g.setFont(this.prop.getFooterFont());
            g.setColor(this.prop.getFooterColor());
        }
        FontMetrics fm = g.getFontMetrics();
        while (true) {
            String val = (String)input.elementAt(i);
            int ind = -1;
            ind = val.indexOf(this.sPageNumber);
            if (ind >= 0) {
                val = this.replace(val, this.sPageNumber, String.valueOf(page), ind);
            }
            if ((ind = val.indexOf(this.sSubPageNumber)) >= 0) {
                val = this.replace(val, this.sPageNumber, String.valueOf(subPage), ind);
            }
            int stringWidth = fm.stringWidth(val);
            int start = 0;
            if (align == 0) {
                start = (this.pageWidth - stringWidth) / 2;
            } else if (align == 4) {
                start = this.pageWidth - stringWidth;
            }
            if (start < 0) {
                start = 0;
            }
            g.drawString(val, start, vertical);
            if (topToBottom) {
                vertical += this.headerFontHeight;
                if (++i < input.size()) continue;
                break;
            }
            vertical -= this.footerFontHeight;
            if (--i < 0) break;
        }
    }

    int getTotalPages(Graphics g2) {
        if (!this.pageInfoCalculated) {
            this.getPageInfo(g2);
            this.pageInfoCalculated = true;
        }
        return this.totalNumPages;
    }

    private String replace(String oldValue, String findString, String replaceString, int loc) {
        String newValue = "";
        newValue = loc == 0 ? replaceString : String.valueOf(oldValue.substring(0, loc)) + replaceString;
        if (loc + findString.length() != oldValue.length()) {
            newValue = String.valueOf(newValue) + oldValue.substring(loc + findString.length(), oldValue.length());
        }
        return newValue;
    }
}

