/*
 * Decompiled with CFR 0.152.
 */
package quick.dbtable;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import quick.dbtable.DBTable;
import quick.dbtable.PreviewPanel;

class PrintPreviewFrame
extends Frame
implements WindowListener {
    protected int m_wPage;
    protected int m_hPage;
    protected Choice m_cbScale;
    protected PreviewPanel m_preview;
    private ScrollPane ps;
    private DBTable dbTable;
    Button printButton;
    Button closeButton;
    Button nextButton;
    Button previousButton;

    PrintPreviewFrame(PreviewPanel source, DBTable dbTable, Font localeFont) {
        this.m_preview = source;
        this.dbTable = dbTable;
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        d.height -= 30;
        this.setSize(d);
        this.addWindowListener(this);
        Panel tb = new Panel();
        tb.setBackground(Color.lightGray);
        ActionListener lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("Next")) {
                    PrintPreviewFrame.this.m_preview.next();
                } else if (e.getActionCommand().equals("Previous")) {
                    PrintPreviewFrame.this.m_preview.previous();
                } else if (e.getActionCommand().equals("Close")) {
                    PrintPreviewFrame.this.dispose();
                } else if (e.getActionCommand().equals("Print")) {
                    PrintPreviewFrame.this.dbTable.print(PrintPreviewFrame.this.m_preview.getPrintProperties());
                }
            }
        };
        Button bt = new Button(dbTable.getString("Print"));
        bt.setActionCommand("Print");
        bt.addActionListener(lst);
        this.printButton = bt;
        tb.add(bt);
        bt = new Button(dbTable.getString("Close"));
        bt.setActionCommand("Close");
        bt.addActionListener(lst);
        this.closeButton = bt;
        tb.add(bt);
        this.m_cbScale = new Choice();
        this.m_cbScale.addItem("10 %");
        this.m_cbScale.addItem("25 %");
        this.m_cbScale.addItem("50 %");
        this.m_cbScale.addItem("75 %");
        this.m_cbScale.addItem("100 %");
        this.m_cbScale.select(4);
        ItemListener il = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                String str = PrintPreviewFrame.this.m_cbScale.getSelectedItem().toString();
                if (str.endsWith("%")) {
                    str = str.substring(0, str.length() - 1);
                }
                str = str.trim();
                int scale = 100;
                try {
                    scale = Integer.parseInt(str);
                }
                catch (NumberFormatException ex) {
                    return;
                }
                PrintPreviewFrame.this.m_preview.setScale(scale);
                PrintPreviewFrame.this.ps.doLayout();
            }
        };
        this.m_cbScale.addItemListener(il);
        tb.add(this.m_cbScale);
        bt = new Button(dbTable.getString("Next"));
        bt.setActionCommand("Next");
        bt.addActionListener(lst);
        this.nextButton = bt;
        tb.add(bt);
        bt = new Button(dbTable.getString("Previous"));
        bt.setActionCommand("Previous");
        bt.addActionListener(lst);
        this.previousButton = bt;
        tb.add(bt);
        this.add((Component)tb, "North");
        this.ps = new ScrollPane(0);
        this.ps.add(source);
        this.add((Component)this.ps, "Center");
        if (localeFont != null) {
            this.resetFont(localeFont);
        }
    }

    void resetFont(Font fnt) {
        this.setFont(fnt);
        this.printButton.setFont(fnt);
        this.closeButton.setFont(fnt);
        this.nextButton.setFont(fnt);
        this.previousButton.setFont(fnt);
    }

    public void windowClosing(WindowEvent evt) {
        this.dispose();
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }
}

