/*
 * Decompiled with CFR 0.152.
 */
package quick.dbtable;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import quick.dbtable.PrintProperties;
import quick.dbtable.PrintableTable;

public class PreviewPanel
extends Canvas {
    protected final int H_GAP = 16;
    protected final int V_GAP = 10;
    private PrintableTable prn;
    private int scale = 100;
    private Image imageSource;
    private Image scaledImage;
    private boolean scaleChanged = true;
    private boolean pageChanged = true;
    private int pageIndex = 0;
    private Dimension size = null;
    private int oldPageIndex = 0;

    PreviewPanel(PrintableTable prn) {
        this.prn = prn;
        this.calculateSize();
    }

    public void setScale(int percentage) {
        this.scale = percentage;
        this.scaleChanged = true;
        this.calculateSize();
        this.validate();
        this.repaint();
    }

    public void next() {
        this.oldPageIndex = this.pageIndex++;
        this.pageChanged = true;
        this.validate();
        this.repaint();
    }

    public void previous() {
        if (this.pageIndex == 0) {
            return;
        }
        this.oldPageIndex = this.pageIndex--;
        this.pageChanged = true;
        this.validate();
        this.repaint();
    }

    public void goTo(int i) {
        this.pageIndex = i;
        this.pageChanged = true;
        this.validate();
        this.repaint();
    }

    public Dimension getMinimumSize() {
        return this.size;
    }

    public Dimension getPreferredSize() {
        return this.size;
    }

    private void calculateSize() {
        this.size = new Dimension(this.prn.getPrintProperties().getPaperWidth() * this.scale / 100, this.prn.getPrintProperties().getPaperHeight() * this.scale / 100);
    }

    public void paint(Graphics g) {
        this.setCursor(new Cursor(3));
        this.setBackground(Color.gray);
        g.setColor(Color.white);
        g.fillRect((this.getSize().width - this.prn.getPrintProperties().getPaperWidth() * this.scale / 100) / 2, (this.getSize().height - this.prn.getPrintProperties().getPaperHeight() * this.scale / 100) / 2, this.prn.getPrintProperties().getPaperWidth() * this.scale / 100, this.prn.getPrintProperties().getPaperHeight() * this.scale / 100);
        if (this.pageChanged) {
            block7: {
                Image oldImage = this.imageSource;
                Frame f = new Frame();
                f.addNotify();
                this.imageSource = f.createImage(this.prn.getPrintProperties().getPaperWidth(), this.prn.getPrintProperties().getPaperHeight());
                Graphics myGraphics = this.imageSource.getGraphics();
                try {
                    if (this.prn.printPage(myGraphics, this.pageIndex) != 1) break block7;
                    this.pageChanged = false;
                    if (oldImage != null) {
                        this.imageSource = oldImage;
                        this.pageIndex = this.oldPageIndex;
                        break block7;
                    }
                    return;
                }
                catch (Exception e) {
                    System.out.println("Error creating");
                    e.printStackTrace();
                }
            }
            Object var3_3 = null;
        }
        if (this.scale == 100) {
            this.scaledImage = this.imageSource;
        } else if (this.pageChanged || this.scaleChanged) {
            this.scaledImage = this.imageSource.getScaledInstance(this.prn.getPrintProperties().getPaperWidth() * this.scale / 100, this.prn.getPrintProperties().getPaperHeight() * this.scale / 100, 4);
            this.scaledImage.flush();
        }
        g.drawImage(this.scaledImage, (this.getSize().width - this.prn.getPrintProperties().getPaperWidth() * this.scale / 100) / 2, (this.getSize().height - this.prn.getPrintProperties().getPaperHeight() * this.scale / 100) / 2, null);
        this.pageChanged = false;
        this.scaleChanged = false;
        this.setCursor(Cursor.getDefaultCursor());
        System.gc();
    }

    public PrintProperties getPrintProperties() {
        return this.prn.getPrintProperties();
    }
}

