/*
 * Decompiled with CFR 0.152.
 */
package quick.dbtable;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import quick.dbtable.DBTable;

class NumericDocument
extends PlainDocument {
    private String validValues = "0123456789";
    private int size;
    private boolean signed;
    private String columnDesc = "";
    private boolean validate = false;
    private String hint = "To hide this message,refer to DBTable.showCriticalWarnings api doc.";
    private DBTable dbTable;

    NumericDocument(int size, int columnIndex, DBTable dbTable) {
        this.size = size;
        if (columnIndex > -1) {
            this.columnDesc = "Column :" + columnIndex + " ";
        }
        this.dbTable = dbTable;
    }

    public void changeSizeTo(int size) {
        this.validate = false;
        this.size = size;
    }

    public void setSigned(boolean val) {
        if (val == this.signed) {
            return;
        }
        this.validate = false;
        if (val) {
            this.validValues = "0123456789+-";
            ++this.size;
        } else {
            this.validValues = "0123456789";
            --this.size;
        }
        this.signed = val;
    }

    private void log(String str, boolean display) {
        if (display && this.dbTable != null && (this.dbTable.debug || this.dbTable.showCriticalWarnings)) {
            System.out.println(String.valueOf(this.columnDesc) + str);
        }
    }

    private void check() {
        int sz;
        int n = sz = this.signed ? this.size - 1 : this.size;
        if (sz <= 0) {
            this.log("Warning: Your JDBC driver or your setting, gives the precision of the column data as " + sz + ".", true);
            this.log("Warning: precision cannot be less than or equal to zero", true);
            this.log("Using yourQT.getColumn(i).setPrecision(20) change the precision", true);
            this.log("Hint: Precision is the length of the numeric column", true);
            this.log(this.hint, true);
        }
    }

    public void insertString(int offs, String str, AttributeSet a) {
        if (!this.validate) {
            this.check();
            this.validate = true;
        }
        try {
            if (str == "" || str == null) {
                return;
            }
            boolean displayMessage = str.length() > 1;
            int newSize = this.size;
            if (this.signed) {
                int signLocation;
                StringBuffer sb = new StringBuffer(this.getText(0, this.getLength()));
                sb.insert(offs, str);
                String newValue = sb.toString();
                int n = signLocation = newValue.lastIndexOf(43) > -1 ? newValue.lastIndexOf(43) : newValue.lastIndexOf(45);
                if (signLocation > 0) {
                    this.log("Sign character is found in location other than one " + newValue + "\n" + this.hint, displayMessage);
                    return;
                }
                if (signLocation == 0) {
                    ++newSize;
                }
            }
            char[] inputChar = str.toCharArray();
            int i = 0;
            while (i < inputChar.length) {
                if (this.validValues.indexOf(inputChar[i]) == -1) {
                    if (this.getLength() + i < this.size) {
                        this.log("Invalid character " + inputChar[i] + " found in value " + str + ". Modify column type using column.setType(), if needed." + "\n" + this.hint, displayMessage);
                        super.insertString(offs, str.substring(0, i), a);
                    } else {
                        this.log("Invalid character " + inputChar[i] + " found in value " + str + ". Modify column type using column.setType(), if needed." + "\n" + this.hint, displayMessage);
                    }
                    return;
                }
                ++i;
            }
            if (this.getLength() + str.length() <= this.size) {
                super.insertString(offs, str, a);
            } else {
                super.insertString(offs, str.substring(0, this.size - this.getLength()), a);
            }
        }
        catch (BadLocationException e) {
            System.out.println(e);
        }
    }
}

