/*
 * Decompiled with CFR 0.152.
 */
package quick.dbtable;

import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

class FixedColumnMap
extends AbstractTableModel
implements TableModelListener {
    TableModel model;
    int[] columnMap = new int[0];

    FixedColumnMap() {
    }

    public TableModel getModel() {
        return this.model;
    }

    public void setModel(TableModel model) {
        this.model = model;
        model.addTableModelListener(this);
    }

    public void setColumns(int[] columns) {
        int colCount = this.model.getColumnCount();
        int i = 0;
        while (i < columns.length) {
            if (columns[i] > colCount || columns[i] < 1) {
                throw new RuntimeException("Table Model Error: RequestedCol :" + columns[i] + " Available Col Count:" + colCount);
            }
            ++i;
        }
        this.columnMap = columns;
        this.fireTableChanged(new TableModelEvent(this));
    }

    public int[] getColumns() {
        return this.columnMap;
    }

    public Object getValueAt(int aRow, int aColumn) {
        Object val = this.model.getValueAt(aRow, this.getColumnFromViewToNextModel(aColumn));
        return val;
    }

    public void setValueAt(Object aValue, int aRow, int aColumn) {
        this.model.setValueAt(aValue, aRow, this.getColumnFromViewToNextModel(aColumn));
    }

    public int getRowCount() {
        int c = this.model.getRowCount();
        return c;
    }

    public int getColumnCount() {
        return this.columnMap.length;
    }

    public String getColumnName(int aColumn) {
        return this.model.getColumnName(this.getColumnFromViewToNextModel(aColumn));
    }

    public Class getColumnClass(int aColumn) {
        return this.model.getColumnClass(this.getColumnFromViewToNextModel(aColumn));
    }

    public boolean isCellEditable(int row, int column) {
        return this.model.isCellEditable(row, this.getColumnFromViewToNextModel(column));
    }

    public int getColumnFromViewToNextModel(int col) {
        if (col < this.columnMap.length) {
            return this.columnMap[col];
        }
        System.out.println("Table Model Error: RequestedCol :" + col + " Available Col Count:" + this.columnMap.length);
        return -1;
    }

    public void tableChanged(TableModelEvent e) {
        super.fireTableChanged(new TableModelEvent(this));
    }
}

