/*
 * Decompiled with CFR 0.152.
 */
package quick.dbtable;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import quick.dbtable.DBTable;
import quick.dbtable.SimpleGridBagConstraints;

class FindFrame
extends JDialog {
    JPanel buttonPanel = new JPanel();
    JPanel mainPanel = new JPanel();
    JPanel replacePanel = new JPanel();
    JPanel findPanel = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JLabel jLabel1 = new JLabel();
    JComboBox findCombo = new JComboBox();
    JLabel jLabel2 = new JLabel();
    JComboBox replaceCombo = new JComboBox();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JButton nextButton = new JButton();
    JButton previousButton = new JButton();
    JButton replaceAllButton = new JButton();
    JButton closeButton = new JButton();
    JPanel jPanel1 = new JPanel();
    JCheckBox startCheckbox = new JCheckBox();
    DBTable dbTable;
    Vector columnVector;
    Point lastLoc = new Point(0, 1);
    boolean find = true;

    FindFrame(Frame f, DBTable dbTable) {
        super(f, false);
        this.dbTable = dbTable;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    FindFrame() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.dbTable.setFnt(this);
        this.mainPanel.setLayout(this.borderLayout1);
        this.findPanel.setLayout(this.gridBagLayout1);
        this.replacePanel.setLayout(this.gridBagLayout2);
        this.jLabel1.setText(this.dbTable.getString("TextToFind"));
        this.jLabel1.setLabelFor(this.findCombo);
        this.dbTable.setFnt(this.jLabel1);
        this.jLabel2.setLabelFor(this.replaceCombo);
        this.dbTable.setFnt(this.jLabel2);
        this.nextButton.setText(this.dbTable.getString("FindNext"));
        this.getRootPane().setDefaultButton(this.nextButton);
        this.dbTable.setFnt(this.nextButton);
        this.previousButton.setText(this.dbTable.getString("FindPrevious"));
        this.dbTable.setFnt(this.previousButton);
        this.replaceAllButton.setText(this.dbTable.getString("ReplaceAll"));
        this.dbTable.setFnt(this.replaceAllButton);
        this.closeButton.setText(this.dbTable.getString("Close"));
        this.dbTable.setFnt(this.closeButton);
        this.startCheckbox.setText(this.dbTable.getString("FromSelectedRow"));
        this.dbTable.setFnt(this.startCheckbox);
        this.jLabel2.setText(this.dbTable.getString("ReplaceWith"));
        this.findCombo.setEditable(true);
        this.replaceCombo.setEditable(true);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        ((FlowLayout)this.buttonPanel.getLayout()).setAlignment(1);
        ((FlowLayout)this.buttonPanel.getLayout()).setVgap(3);
        this.buttonPanel.add((Component)this.nextButton, null);
        this.buttonPanel.add((Component)this.previousButton, null);
        this.buttonPanel.add((Component)this.replaceAllButton, null);
        this.buttonPanel.add((Component)this.closeButton, null);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.mainPanel.add((Component)this.findPanel, "North");
        this.findPanel.add((Component)this.jLabel1, new SimpleGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(7, 20, 0, 0), 0, 9));
        this.findPanel.add((Component)this.findCombo, new SimpleGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(7, 5, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.replacePanel, "Center");
        this.replacePanel.add((Component)this.jLabel2, new SimpleGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 9));
        this.replacePanel.add((Component)this.replaceCombo, new SimpleGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(7, 5, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.jPanel1, "South");
        ((FlowLayout)this.jPanel1.getLayout()).setAlignment(1);
        ((FlowLayout)this.jPanel1.getLayout()).setVgap(3);
        this.jPanel1.add((Component)this.startCheckbox, null);
        FindAction findAction = new FindAction();
        this.nextButton.addActionListener(findAction);
        this.previousButton.addActionListener(findAction);
        this.replaceAllButton.addActionListener(findAction);
        this.closeButton.addActionListener(findAction);
        this.startCheckbox.addActionListener(findAction);
        ChangeListener cl = new ChangeListener();
        this.findCombo.addItemListener(cl);
        this.replaceCombo.addItemListener(cl);
    }

    void resetFont(Font fnt) {
        this.setFont(fnt);
        this.jLabel1.setFont(fnt);
        this.nextButton.setFont(fnt);
        this.previousButton.setFont(fnt);
        this.replaceAllButton.setFont(fnt);
        this.closeButton.setFont(fnt);
        this.startCheckbox.setFont(fnt);
        this.jLabel2.setFont(fnt);
    }

    public void setFind() {
        this.find = true;
        this.replacePanel.setVisible(false);
        this.nextButton.setText(this.dbTable.getString("FindNext"));
        this.previousButton.setText(this.dbTable.getString("FindPrevious"));
        this.replaceAllButton.setVisible(false);
        this.setSize(440, 150);
    }

    public void setReplace() {
        this.find = false;
        this.replacePanel.setVisible(true);
        this.nextButton.setText(this.dbTable.getString("ReplaceNext"));
        this.previousButton.setText(this.dbTable.getString("ReplacePrevious"));
        this.replaceAllButton.setVisible(true);
        this.setSize(440, 190);
    }

    public void setRow(int row) {
        if (this.startCheckbox.isSelected()) {
            this.lastLoc = row >= 0 ? new Point(row, -1) : new Point(0, -1);
        }
    }

    void findNext() {
        if (!this.validateInput()) {
            return;
        }
        String findText = (String)this.findCombo.getSelectedItem();
        this.refreshColumnVector(this.dbTable.getTable());
        if (this.dbTable.lastLoc == -1) {
            if (this.lastLoc.y == this.columnVector.size() - 1) {
                ++this.lastLoc.x;
                this.lastLoc.y = 0;
            } else {
                ++this.lastLoc.y;
            }
        }
        this.lastLoc = this.dbTable.find(this.lastLoc.x, this.lastLoc.y, findText, this.columnVector, true);
    }

    private void refreshColumnVector(JTable jt) {
        int colCount = jt.getColumnCount();
        if (this.columnVector == null) {
            this.columnVector = new Vector();
        }
        if (colCount != this.columnVector.size()) {
            this.columnVector.removeAllElements();
            int i = 0;
            while (i < colCount) {
                this.columnVector.addElement(new Integer(i + 1));
                ++i;
            }
        }
    }

    private boolean validateInput() {
        String replaceText;
        String findText = (String)this.findCombo.getSelectedItem();
        if (findText == null || "".equals(findText)) {
            return false;
        }
        return this.find || (replaceText = (String)this.replaceCombo.getSelectedItem()) != null && !"".equals(replaceText);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            int startRow;
            this.lastLoc = this.startCheckbox.isSelected() ? ((startRow = this.dbTable.getTable().getSelectedRow()) >= 0 ? new Point(startRow, -1) : new Point(0, -1)) : new Point(0, -1);
            this.center();
            this.toFront();
            this.findCombo.requestDefaultFocus();
            this.findCombo.requestFocus();
        } else {
            this.dbTable.lastLoc = -1;
        }
        super.setVisible(visible);
    }

    public void center() {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
    }

    class ChangeListener
    implements ItemListener {
        ChangeListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            JComboBox cb = (JComboBox)e.getSource();
            String text = (String)cb.getSelectedItem();
            if (text == null || "".equals(text)) {
                return;
            }
            boolean exists = false;
            int i = 0;
            while (i < cb.getItemCount()) {
                if (text.equals(cb.getItemAt(i))) {
                    exists = true;
                    break;
                }
                ++i;
            }
            if (!exists) {
                cb.addItem(text);
            }
        }
    }

    class FindAction
    implements ActionListener {
        FindAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTable jt = FindFrame.this.dbTable.getTable();
            if (e.getSource() == FindFrame.this.closeButton) {
                FindFrame.this.setVisible(false);
                return;
            }
            if (e.getSource() == FindFrame.this.startCheckbox) {
                int startRow;
                FindFrame.this.lastLoc = FindFrame.this.startCheckbox.isSelected() ? ((startRow = jt.getSelectedRow()) >= 0 ? new Point(startRow, -1) : new Point(0, -1)) : new Point(0, -1);
                return;
            }
            if (FindFrame.this.find) {
                if (e.getSource() == FindFrame.this.nextButton) {
                    FindFrame.this.findNext();
                } else if (e.getSource() == FindFrame.this.previousButton) {
                    if (!FindFrame.this.validateInput()) {
                        return;
                    }
                    String findText = (String)FindFrame.this.findCombo.getSelectedItem();
                    FindFrame.this.refreshColumnVector(jt);
                    if (FindFrame.this.dbTable.lastLoc == -1) {
                        if (FindFrame.this.lastLoc.y == 0) {
                            --FindFrame.this.lastLoc.x;
                            FindFrame.this.lastLoc.y = FindFrame.this.columnVector.size() - 1;
                        } else {
                            --FindFrame.this.lastLoc.y;
                        }
                    }
                    FindFrame.this.lastLoc = FindFrame.this.dbTable.find(FindFrame.this.lastLoc.x, FindFrame.this.lastLoc.y, findText, FindFrame.this.columnVector, false);
                }
            } else if (e.getSource() == FindFrame.this.nextButton || e.getSource() == FindFrame.this.findCombo) {
                if (!FindFrame.this.validateInput()) {
                    return;
                }
                String findText = (String)FindFrame.this.findCombo.getSelectedItem();
                String replaceText = (String)FindFrame.this.replaceCombo.getSelectedItem();
                FindFrame.this.refreshColumnVector(jt);
                if (FindFrame.this.lastLoc.y == FindFrame.this.columnVector.size() - 1) {
                    ++FindFrame.this.lastLoc.x;
                    FindFrame.this.lastLoc.y = 0;
                } else {
                    ++FindFrame.this.lastLoc.y;
                }
                FindFrame.this.setVisible(false);
                FindFrame.this.lastLoc = FindFrame.this.dbTable.replace(FindFrame.this.lastLoc.x, FindFrame.this.lastLoc.y, findText, replaceText, FindFrame.this.columnVector, true);
            } else if (e.getSource() == FindFrame.this.previousButton) {
                if (!FindFrame.this.validateInput()) {
                    return;
                }
                String findText = (String)FindFrame.this.findCombo.getSelectedItem();
                String replaceText = (String)FindFrame.this.replaceCombo.getSelectedItem();
                FindFrame.this.refreshColumnVector(jt);
                if (FindFrame.this.lastLoc.y == 0) {
                    --FindFrame.this.lastLoc.x;
                    FindFrame.this.lastLoc.y = FindFrame.this.columnVector.size() - 1;
                } else {
                    --FindFrame.this.lastLoc.y;
                }
                FindFrame.this.setVisible(false);
                FindFrame.this.lastLoc = FindFrame.this.dbTable.replace(FindFrame.this.lastLoc.x, FindFrame.this.lastLoc.y, findText, replaceText, FindFrame.this.columnVector, false);
            } else if (e.getSource() == FindFrame.this.replaceAllButton) {
                String findText = (String)FindFrame.this.findCombo.getSelectedItem();
                if (findText == null || "".equals(findText)) {
                    return;
                }
                String replaceText = (String)FindFrame.this.replaceCombo.getSelectedItem();
                if (replaceText == null || "".equals(replaceText)) {
                    return;
                }
                FindFrame.this.refreshColumnVector(jt);
                FindFrame.this.setVisible(false);
                FindFrame.this.lastLoc = FindFrame.this.dbTable.replaceAll(0, 1, findText, replaceText, FindFrame.this.columnVector);
            }
            jt.repaint();
        }
    }
}

