/*
 * Decompiled with CFR 0.152.
 */
package quick.dbtable;

import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import quick.dbtable.DBTable;
import quick.dbtable.DBTableEventListener;

class ExtendedJTable
extends JTable {
    DBTable dbTable;

    ExtendedJTable(DBTable dbTable, TableModel tableSorter, TableColumnModel dbColumnModel) {
        super(tableSorter, dbColumnModel);
        this.dbTable = dbTable;
    }

    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        int oldRow = this.getSelectedRow();
        int oldColumn = this.getSelectedColumn();
        int n = oldColumn = oldColumn >= 0 ? this.dbTable.getOriginalColumnIndex(oldColumn) : oldColumn;
        if (oldColumn != columnIndex) {
            boolean forward = false;
            if (rowIndex > oldRow) {
                forward = true;
            } else if (columnIndex - oldColumn == 1) {
                forward = true;
            } else if (oldColumn - columnIndex > 1) {
                forward = true;
            }
            while (!this.dbTable.getColumn(columnIndex).isVisible()) {
                if (forward) {
                    if (columnIndex == this.dbTable.getColumnCount() - 1) {
                        if (rowIndex != this.dbTable.getRowCount() - 1) {
                            columnIndex = 0;
                            ++rowIndex;
                            continue;
                        }
                        columnIndex = 0;
                        rowIndex = 0;
                        continue;
                    }
                    ++columnIndex;
                    continue;
                }
                if (columnIndex == 0) {
                    if (rowIndex != 0) {
                        columnIndex = this.dbTable.getColumnCount() - 1;
                        --rowIndex;
                        continue;
                    }
                    rowIndex = this.dbTable.getRowCount() - 1;
                    columnIndex = this.dbTable.getColumnCount() - 1;
                    continue;
                }
                --columnIndex;
            }
        }
        int newColumn = columnIndex >= 0 ? this.dbTable.getOriginalColumnIndex(columnIndex) : columnIndex;
        boolean allowSelectionChange = true;
        try {
            int i;
            if (oldRow != rowIndex && rowIndex != -1) {
                i = 0;
                while (this.dbTable.eventListenerVector != null && i < this.dbTable.eventListenerVector.size()) {
                    if (!((DBTableEventListener)this.dbTable.eventListenerVector.elementAt(i)).beforeRowSelectionChange(oldRow, rowIndex, oldColumn, newColumn)) {
                        allowSelectionChange = false;
                    }
                    ++i;
                }
            }
            if (oldColumn != newColumn && newColumn != -1) {
                i = 0;
                while (this.dbTable.eventListenerVector != null && i < this.dbTable.eventListenerVector.size()) {
                    if (!((DBTableEventListener)this.dbTable.eventListenerVector.elementAt(i)).beforeColumnSelectionChange(oldColumn, newColumn, oldRow, rowIndex)) {
                        allowSelectionChange = false;
                    }
                    ++i;
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (allowSelectionChange) {
            super.changeSelection(rowIndex, columnIndex, toggle, extend);
        } else {
            if (this.dbTable.debug) {
                System.out.println("Selection change not allowed by DBTableEventListener");
            }
            if (this.isEditing()) {
                this.editingCanceled(new ChangeEvent(this));
            }
        }
    }
}

