/*
 * Decompiled with CFR 0.152.
 */
package quick.dbtable;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import quick.dbtable.DBTable;
import quick.dbtable.DBTypeMap;

class ExcelHandler
implements ActionListener {
    private String rowstring;
    private String value;
    private Clipboard system;
    private StringSelection stsel;
    private JTable jTable1;
    private DBTable dbTable;

    ExcelHandler(DBTable myTable) {
        this.dbTable = myTable;
        this.jTable1 = myTable.getTable();
        KeyStroke copy = KeyStroke.getKeyStroke(67, 2, false);
        KeyStroke paste = KeyStroke.getKeyStroke(86, 2, false);
        this.jTable1.registerKeyboardAction(this, "Copy", copy, 1);
        this.jTable1.registerKeyboardAction(this, "Paste", paste, 1);
        this.system = Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    public JTable getJTable() {
        return this.jTable1;
    }

    public void setJTable(JTable jTable1) {
        this.jTable1 = jTable1;
    }

    protected void copy(int[] row) {
        StringBuffer sbf = new StringBuffer();
        int numcols = this.jTable1.getColumnCount();
        int numrows = this.jTable1.getSelectedRowCount();
        int[] rowsselected = null;
        rowsselected = row != null ? row : this.jTable1.getSelectedRows();
        boolean[] isVisible = new boolean[numcols];
        int j = 0;
        while (j < numcols) {
            isVisible[j] = this.dbTable.getColumn(j).isVisible();
            ++j;
        }
        if (this.dbTable.copyColumnHeaderNames) {
            j = 0;
            while (j < numcols) {
                if (isVisible[j]) {
                    String val = this.dbTable.getColumn(j).getColumnName();
                    sbf.append(val == null ? "" : val);
                    if (j < numcols - 1) {
                        sbf.append("\t");
                    }
                }
                ++j;
            }
            sbf.append("\n");
        }
        boolean[] useRendererData = this.dbTable.getRendererArray();
        int i = 0;
        while (i < numrows) {
            int j2 = 0;
            while (j2 < numcols) {
                if (isVisible[j2]) {
                    Object val = null;
                    val = useRendererData[j2] ? this.dbTable.getRendererText(rowsselected[i], j2) : this.jTable1.getValueAt(rowsselected[i], j2);
                    sbf.append(val == null ? "" : val);
                    if (j2 < numcols - 1) {
                        sbf.append("\t");
                    }
                }
                ++j2;
            }
            sbf.append("\n");
            ++i;
        }
        this.stsel = new StringSelection(sbf.toString());
        this.system = Toolkit.getDefaultToolkit().getSystemClipboard();
        this.system.setContents(this.stsel, this.stsel);
    }

    protected void paste() {
        int startRow = this.jTable1.getSelectedRows()[0];
        int startCol = 0;
        boolean[] useRendererData = this.dbTable.getRendererArray();
        try {
            Transferable trans = this.system.getContents(this);
            if (trans == null) {
                return;
            }
            String trstring = (String)trans.getTransferData(DataFlavor.stringFlavor);
            StringTokenizer st1 = new StringTokenizer(trstring, "\n");
            int i = 0;
            while (st1.hasMoreTokens()) {
                this.rowstring = String.valueOf(st1.nextToken()) + "\t";
                StringTokenizer st2 = new StringTokenizer(this.rowstring, "\t", true);
                boolean lastTokenIsTab = true;
                Vector<Object> rowData = new Vector<Object>();
                int j = 0;
                while (st2.hasMoreTokens()) {
                    this.value = st2.nextToken();
                    if ("\t".equals(this.value)) {
                        if (!lastTokenIsTab) {
                            lastTokenIsTab = true;
                            continue;
                        }
                        lastTokenIsTab = true;
                        this.value = null;
                    } else {
                        lastTokenIsTab = false;
                    }
                    if (startCol + j >= this.jTable1.getColumnCount()) continue;
                    Object data = null;
                    try {
                        data = useRendererData[j] ? this.dbTable.getEditorValue(0, startCol + j, this.value) : DBTypeMap.createObject(this.jTable1.getRowCount() > 0 ? this.jTable1.getValueAt(0, startCol + j) : null, this.dbTable.getColumnAsCreated(startCol + j), this.value);
                    }
                    catch (Exception e) {
                        System.out.println("Excel paste error: " + e.getMessage());
                        data = "";
                    }
                    rowData.addElement(data == null ? "" : data);
                    ++j;
                }
                while (startCol + j < this.jTable1.getColumnCount()) {
                    rowData.addElement("");
                    ++j;
                }
                this.dbTable.insert(rowData);
                ++i;
            }
            this.jTable1.scrollRectToVisible(this.jTable1.getCellRect(this.jTable1.getRowCount() - i, 1, true));
            this.jTable1.setRowSelectionInterval(this.jTable1.getRowCount() - i, this.jTable1.getRowCount() - 1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().compareTo("Copy") == 0) {
            this.copy(null);
        } else if (e.getActionCommand().compareTo("Paste") == 0 && !this.jTable1.isEditing()) {
            this.paste();
        }
    }
}

