/*
 * Decompiled with CFR 0.152.
 */
package quick.dbtable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import quick.dbtable.CellComponent;
import quick.dbtable.CellPropertiesModel;
import quick.dbtable.Column;
import quick.dbtable.DBTable;
import quick.dbtable.DBTableCalendar;

public class DBTableCellEditor
implements TableCellEditor,
Serializable {
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;
    protected JComponent editorComponent;
    protected JComponent secondaryEditorComponent;
    protected EditorDelegate delegate;
    protected int clickCountToStart = 1;
    protected int cellType = -1;
    private Hashtable cellValueToDisplayHash = null;
    private DBTable dBTable = null;
    private CellComponent cc;

    public DBTableCellEditor(JTextField jt, DBTable dBTable) {
        this.createCellEditor(3, null, dBTable, jt, true);
    }

    public DBTableCellEditor(JTextArea jt, DBTable dBTable) {
        this.createCellEditor(6, null, dBTable, jt, true);
    }

    public DBTableCellEditor(CellComponent cc, DBTable dBTable) {
        this.cellType = 7;
        this.dBTable = dBTable;
        this.cc = cc;
        this.editorComponent = cc.getComponent();
        this.clickCountToStart = dBTable.defaultClickCountToStartEditor;
        this.delegate = new EditorDelegate(){

            public void setValue(Object value, JTable jt, int row, int col) {
                DBTableCellEditor.this.setCellProperties(DBTableCellEditor.this.editorComponent, DBTableCellEditor.this.cellType, jt, row, col);
                DBTableCellEditor.this.cc.setValue(value);
            }

            public Object getCellEditorValue() {
                return DBTableCellEditor.this.cc.getValue();
            }
        };
    }

    public DBTableCellEditor(JComboBox jc, DBTable dBTable) {
        this.createCellEditor(5, null, dBTable, jc, true);
    }

    public DBTableCellEditor(int cellType, Hashtable cellValueToDisplayHashtable, DBTable dBTable) {
        this.createCellEditor(cellType, cellValueToDisplayHashtable, dBTable, null, true);
    }

    public DBTableCellEditor(int cellType, Hashtable cellValueToDisplayHashtable, DBTable dBTable, boolean addClearOption) {
        this.createCellEditor(cellType, cellValueToDisplayHashtable, null, dBTable, null, addClearOption);
    }

    public DBTableCellEditor(int cellType, Hashtable cellValueToDisplayHashtable, Object[] keysSortOrder, DBTable dBTable, boolean addClearOption) {
        this.createCellEditor(cellType, cellValueToDisplayHashtable, keysSortOrder, dBTable, null, addClearOption);
    }

    private void createCellEditor(int cellType, Hashtable cellValueToDisplayHashtable, DBTable dBTable, JComponent comp, boolean addClearOption) {
        this.createCellEditor(cellType, cellValueToDisplayHashtable, null, dBTable, comp, addClearOption);
    }

    private void createCellEditor(final int cellType, Hashtable cellValueToDisplayHashtable, Object[] keysSortOrder, final DBTable dBTable, JComponent comp, boolean addClearOption) {
        this.cellType = cellType;
        this.cellValueToDisplayHash = cellValueToDisplayHashtable;
        this.dBTable = dBTable;
        this.clickCountToStart = dBTable.defaultClickCountToStartEditor;
        if (cellType == 7) {
            throw new RuntimeException("USER cell cannot be created using this constructor, please use the constructor DBTableCellEditor(CellComponent, DBTable)");
        }
        if (cellValueToDisplayHashtable == null && cellType != 3 && cellType != 5 && cellType != 7 && cellType != 6) {
            throw new RuntimeException("cellValueToDisplayHashtable cannot be null");
        }
        switch (cellType) {
            case 0: {
                JComboBox<Icon> comboBox;
                this.editorComponent = comboBox = new JComboBox<Icon>();
                this.editorComponent.setOpaque(true);
                this.setComboValues(comboBox, keysSortOrder, cellValueToDisplayHashtable);
                if (addClearOption) {
                    comboBox.addItem(Column.getEmptyIcon());
                }
                this.delegate = new EditorDelegate(){

                    public void setValue(Object value, JTable jt, int row, int col) {
                        DBTableCellEditor.this.setCellProperties(DBTableCellEditor.this.editorComponent, cellType, jt, row, col);
                        if (value == null || "".equals(value)) {
                            comboBox.setSelectedItem(Column.getEmptyIcon());
                        } else {
                            Object o = DBTableCellEditor.this.cellValueToDisplayHash.get(value);
                            if (o != null) {
                                comboBox.setSelectedItem(o);
                                return;
                            }
                            if (!(value instanceof String) && (o = DBTableCellEditor.this.cellValueToDisplayHash.get(value.toString())) != null) {
                                comboBox.setSelectedItem(o);
                                return;
                            }
                            ((JComboBox)DBTableCellEditor.this.editorComponent).setSelectedItem(Column.getEmptyIcon());
                        }
                    }

                    public Object getCellEditorValue() {
                        if (Column.getEmptyIcon().equals(comboBox.getSelectedItem())) {
                            return "";
                        }
                        return DBTableCellEditor.this.get(comboBox.getSelectedItem());
                    }

                    boolean shouldSelectCell(EventObject anEvent) {
                        if (anEvent instanceof MouseEvent) {
                            MouseEvent me = (MouseEvent)anEvent;
                            return me.getID() != 506;
                        }
                        return true;
                    }
                };
                comboBox.addActionListener(this.delegate);
                break;
            }
            case 1: {
                final JCheckBox checkBox = new JCheckBox();
                this.editorComponent = checkBox;
                this.editorComponent.setOpaque(true);
                this.delegate = new EditorDelegate(){

                    public void setValue(Object value, JTable jt, int row, int col) {
                        DBTableCellEditor.this.setCellProperties(DBTableCellEditor.this.editorComponent, cellType, jt, row, col);
                        if (value == null) {
                            checkBox.setSelected(false);
                        } else {
                            Object o = DBTableCellEditor.this.cellValueToDisplayHash.get(value);
                            if (o != null) {
                                checkBox.setSelected((Boolean)o);
                                return;
                            }
                            if (!(value instanceof String) && (o = DBTableCellEditor.this.cellValueToDisplayHash.get(value.toString())) != null) {
                                checkBox.setSelected((Boolean)o);
                                return;
                            }
                            checkBox.setSelected(false);
                        }
                    }

                    public Object getCellEditorValue() {
                        return DBTableCellEditor.this.get(new Boolean(checkBox.isSelected()));
                    }
                };
                checkBox.addActionListener(this.delegate);
                break;
            }
            case 2: {
                final JRadioButton radioButton = new JRadioButton();
                this.editorComponent = radioButton;
                this.editorComponent.setOpaque(true);
                this.delegate = new EditorDelegate(){

                    public void setValue(Object value, JTable jt, int row, int col) {
                        DBTableCellEditor.this.setCellProperties(DBTableCellEditor.this.editorComponent, cellType, jt, row, col);
                        if (value == null) {
                            radioButton.setSelected(false);
                        } else {
                            Object o = DBTableCellEditor.this.cellValueToDisplayHash.get(value);
                            if (o != null) {
                                radioButton.setSelected((Boolean)o);
                                return;
                            }
                            if (!(value instanceof String) && (o = DBTableCellEditor.this.cellValueToDisplayHash.get(value.toString())) != null) {
                                radioButton.setSelected((Boolean)o);
                                return;
                            }
                            radioButton.setSelected(false);
                        }
                    }

                    public Object getCellEditorValue() {
                        return DBTableCellEditor.this.get(new Boolean(radioButton.isSelected()));
                    }
                };
                radioButton.addActionListener(this.delegate);
                break;
            }
            case 5: {
                if (comp == null) {
                    JComboBox jcb;
                    comp = jcb = new JComboBox();
                }
                final JComboBox comboBox = comp;
                if (this.cellValueToDisplayHash != null) {
                    this.setComboValues(comboBox, keysSortOrder, cellValueToDisplayHashtable);
                    if (addClearOption) {
                        comboBox.addItem("");
                    }
                }
                this.editorComponent = comp;
                this.delegate = new EditorDelegate(){

                    public void setValue(Object value, JTable jt, int row, int col) {
                        DBTableCellEditor.this.setCellProperties(DBTableCellEditor.this.editorComponent, cellType, jt, row, col);
                        if (DBTableCellEditor.this.cellValueToDisplayHash == null) {
                            if (value == null || "".equals(value)) {
                                comboBox.setSelectedItem("");
                            } else {
                                comboBox.setSelectedItem(value.toString());
                            }
                        } else if (value == null || "".equals(value)) {
                            comboBox.setSelectedItem("");
                        } else {
                            Object o = DBTableCellEditor.this.cellValueToDisplayHash.get(value);
                            if (o != null) {
                                comboBox.setSelectedItem(o);
                                return;
                            }
                            if (!(value instanceof String) && (o = DBTableCellEditor.this.cellValueToDisplayHash.get(value.toString())) != null) {
                                comboBox.setSelectedItem(o);
                                return;
                            }
                            ((JComboBox)DBTableCellEditor.this.editorComponent).setSelectedItem("");
                        }
                    }

                    public Object getCellEditorValue() {
                        return this.convertDisplayToActual(comboBox.getSelectedItem());
                    }

                    public Object convertDisplayToActual(Object input) {
                        if (DBTableCellEditor.this.cellValueToDisplayHash != null) {
                            if ("".equals(input)) {
                                return "";
                            }
                            return DBTableCellEditor.this.get(input);
                        }
                        return input;
                    }

                    boolean shouldSelectCell(EventObject anEvent) {
                        if (anEvent instanceof MouseEvent) {
                            MouseEvent e = (MouseEvent)anEvent;
                            return e.getID() != 506;
                        }
                        return true;
                    }
                };
                comboBox.addActionListener(this.delegate);
                break;
            }
            case 4: {
                if (comp == null) {
                    comp = new JTextField();
                }
                JTextField textField = (JTextField)((Object)comp);
                textField.setEditable(false);
                textField.setEnabled(false);
                this.editorComponent = textField;
                SimpleDateFormat toFormat = (SimpleDateFormat)cellValueToDisplayHashtable.get("pattern");
                SimpleDateFormat patt = (SimpleDateFormat)this.cellValueToDisplayHash.get("pattern");
                if (patt == null) {
                    patt = new SimpleDateFormat();
                    System.out.println("For date type column, new DBTableCellEditor constructor should not be used. Use column.setType method");
                }
                SimpleDateFormat pattern = patt;
                this.delegate = new DateDelegate(toFormat, textField);
                textField.addActionListener(this.delegate);
                break;
            }
            case 6: {
                if (comp == null) {
                    comp = new JTextArea(".");
                }
                final JTextArea textField = (JTextArea)((Object)comp);
                textField.setLineWrap(true);
                textField.setWrapStyleWord(true);
                this.editorComponent = new JScrollPane(textField);
                this.delegate = new EditorDelegate(){

                    public void setValue(Object value, JTable jt, int row, int col) {
                        DBTableCellEditor.this.setCellProperties(DBTableCellEditor.this.editorComponent, cellType, jt, row, col);
                        textField.setText(value != null ? value.toString() : "");
                    }

                    public Object getCellEditorValue() {
                        return textField.getText();
                    }
                };
                break;
            }
            default: {
                if (comp == null) {
                    comp = new JTextField();
                }
                final JTextField textField = (JTextField)((Object)comp);
                if (dBTable.enableTextOverwriteOnCellEdit) {
                    textField.addFocusListener(new FocusAdapter(){

                        public void focusGained(FocusEvent e) {
                            textField.selectAll();
                        }
                    });
                }
                textField.setEditable(true);
                textField.setEnabled(true);
                this.editorComponent = textField;
                this.delegate = new EditorDelegate(){

                    public void setValue(Object value, JTable jt, int row, int col) {
                        DBTableCellEditor.this.setCellProperties(DBTableCellEditor.this.editorComponent, cellType, jt, row, col);
                        textField.setText(value != null ? value.toString() : "");
                        if (dBTable.enableTextOverwriteOnCellEdit) {
                            textField.selectAll();
                        }
                    }

                    public Object getCellEditorValue() {
                        return textField.getText();
                    }
                };
                textField.addActionListener(this.delegate);
            }
        }
    }

    public int getCellType() {
        return this.cellType;
    }

    private Object get(Object o) {
        Enumeration e = this.cellValueToDisplayHash.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object val = this.cellValueToDisplayHash.get(key);
            if (!val.equals(o)) continue;
            return key;
        }
        return null;
    }

    private void setComboValues(JComboBox comboBox, Object[] keysOrder, Hashtable cellValueToDisplayHashtable) {
        boolean doNotUseSort = false;
        if (keysOrder != null && keysOrder.length != cellValueToDisplayHashtable.size()) {
            doNotUseSort = true;
            System.out.println("combo box sort Order array size should match with the cellValueToDisplayHashtable size. So not using cmobo box sort order");
        }
        if (keysOrder == null || doNotUseSort) {
            Enumeration e = this.cellValueToDisplayHash.elements();
            while (e.hasMoreElements()) {
                comboBox.addItem(e.nextElement());
            }
        } else {
            int i = 0;
            while (i < keysOrder.length) {
                try {
                    comboBox.addItem(this.cellValueToDisplayHash.get(keysOrder[i]));
                }
                catch (Exception ex) {
                    System.out.println("Key " + keysOrder[i] + " not found in cellValueToDisplayHashtable");
                }
                ++i;
            }
        }
    }

    private void setCellProperties(JComponent comp, int cellType, JTable table, int row, int column) {
        column = this.dBTable.getOriginalColumnIndex(column);
        CellPropertiesModel cellModel = this.dBTable.getCellPropertiesModel();
        comp.setForeground(cellModel.getForeground(row, column) != null ? cellModel.getForeground(row, column) : table.getForeground());
        comp.setBackground((Color)this.dBTable.getSkinProperty("Quicktable.focusCellBackground"));
        comp.setBorder((Border)this.dBTable.getSkinProperty("Quicktable.focusCellHighlightBorder"));
        if (cellModel.getFont(row, column) != null) {
            comp.setFont(cellModel.getFont(row, column));
        } else {
            comp.setFont((Font)this.dBTable.getSkinProperty("Quicktable.tableFont"));
        }
        if (cellType == 3) {
            if (cellModel.getAlignment(row, column) != -1) {
                ((JTextField)comp).setHorizontalAlignment(cellModel.getAlignment(row, column));
            } else {
                ((JTextField)comp).setHorizontalAlignment(2);
            }
        } else if (cellType == 2 || cellType == 1) {
            if (cellModel.getAlignment(row, column) != -1) {
                ((AbstractButton)comp).setHorizontalAlignment(cellModel.getAlignment(row, column));
            } else {
                ((AbstractButton)comp).setHorizontalAlignment(2);
            }
        }
    }

    public Component getComponent() {
        return this.editorComponent;
    }

    public Component getSecondaryEditorComponent() {
        return this.delegate.getSecondaryEditorComponent();
    }

    public void setClickCountToStart(int count) {
        this.clickCountToStart = count;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public Object getCellEditorValue() {
        return this.delegate.getCellEditorValue();
    }

    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= this.clickCountToStart;
        }
        return true;
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return this.delegate.shouldSelectCell(anEvent);
    }

    public boolean stopCellEditing() {
        this.delegate.stopCellEditing();
        this.fireEditingStopped();
        return true;
    }

    public void cancelCellEditing() {
        this.delegate.stopCellEditing();
        this.fireEditingCanceled();
    }

    public Object convertDisplayToActual(Object input) {
        return this.delegate.convertDisplayToActual(input);
    }

    public void addCellEditorListener(CellEditorListener l) {
        this.listenerList.add(CellEditorListener.class, l);
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this.listenerList.remove(CellEditorListener.class, l);
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == CellEditorListener.class) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)listeners[i + 1]).editingStopped(this.changeEvent);
            }
            i -= 2;
        }
    }

    protected void fireEditingCanceled() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == CellEditorListener.class) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)listeners[i + 1]).editingCanceled(this.changeEvent);
            }
            i -= 2;
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.delegate.setValue(value, table, row, column);
        return this.editorComponent;
    }

    class DateDelegate
    extends EditorDelegate {
        DBTableCalendar dbc;
        SimpleDateFormat toFormat;
        JTextField textField;

        DateDelegate(SimpleDateFormat toFormat, JTextField textField) {
            this.toFormat = toFormat;
            this.textField = textField;
            this.dbc = new DBTableCalendar(toFormat, textField, DBTableCellEditor.this.dBTable);
        }

        public void setValue(Object value, JTable jt, int row, int col) {
            DBTableCellEditor.this.setCellProperties(DBTableCellEditor.this.editorComponent, DBTableCellEditor.this.cellType, jt, row, col);
            Date thisDate = null;
            if (value == null || "".equals(value)) {
                this.textField.setText("");
            } else if (!(value instanceof Date)) {
                if (((DBTableCellEditor)DBTableCellEditor.this).dBTable.debug) {
                    System.out.println("This is a date type column. The data object is not a Date object, so today's date will be used");
                }
                thisDate = new Date();
                this.textField.setText("");
            } else {
                thisDate = (Date)value;
                this.textField.setText(this.toFormat.format(thisDate));
            }
            Rectangle rt = jt.getCellRect(row, col, false);
            this.dbc.show(jt, thisDate, rt.x, rt.y + rt.height, row, col);
        }

        public Object getCellEditorValue() {
            if (!"".equals(this.textField.getText())) {
                Date returnDate = this.dbc.getDate();
                if (returnDate != null) {
                    return returnDate;
                }
                return "";
            }
            return "";
        }

        public Component getSecondaryEditorComponent() {
            if (this.dbc == null) {
                return null;
            }
            return this.dbc.getComponent();
        }

        public Object convertDisplayToActual(Object input) {
            try {
                return this.toFormat.parse(input.toString());
            }
            catch (Exception exception) {
                return new Date();
            }
        }

        public boolean stopCellEditing() {
            this.dbc.setVisible(false);
            return true;
        }

        public void cancelCellEditing() {
            this.dbc.setVisible(false);
        }
    }

    protected class EditorDelegate
    implements ActionListener,
    ItemListener,
    Serializable {
        protected Object value;

        protected EditorDelegate() {
        }

        public Object getCellEditorValue() {
            return null;
        }

        public void setValue(Object x, JTable jt, int row, int col) {
        }

        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        public boolean startCellEditing(EventObject anEvent) {
            return true;
        }

        public boolean stopCellEditing() {
            return true;
        }

        public void cancelCellEditing() {
        }

        public void actionPerformed(ActionEvent e) {
            DBTableCellEditor.this.fireEditingStopped();
        }

        public void itemStateChanged(ItemEvent e) {
            DBTableCellEditor.this.fireEditingStopped();
        }

        public Object convertDisplayToActual(Object input) {
            return input;
        }

        public Component getSecondaryEditorComponent() {
            return null;
        }
    }
}

