/*
 * Decompiled with CFR 0.152.
 */
package quick.dbtable;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.SoftBevelBorder;
import quick.dbtable.DBTable;
import quick.dbtable.DayCell;
import quick.dbtable.NumericDocument;
import quick.dbtable.WeekdayCell;

class DBTableCalendarDialog
extends JDialog
implements Serializable,
ItemListener,
KeyListener,
ActionListener {
    SimpleDateFormat format;
    JComboBox month;
    JTextField year;
    JTextField hour;
    JTextField minute;
    JComboBox am;
    JPanel days;
    JPanel monthNyear;
    Font f = new Font("TimesRoman", 1, 10);
    FontMetrics fm;
    int currentDay;
    String[] months;
    int[] monthLength = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    String[] weekdays;
    DayCell[] cells;
    Dimension cellsize;
    int pad = 3;
    JTextField jt;
    int oldX = -1;
    int oldY = -1;
    JButton okButton;
    JButton cancelButton;
    JButton clearButton;
    Date oldDate;
    DBTable dbTable;
    boolean selectingMonth = false;
    Date returnDate = null;
    int row;
    int col;

    DBTableCalendarDialog(SimpleDateFormat dateFormat, JTextField jt, DBTable dbTable) {
        super(dbTable.getTempFrame(), dbTable.getString("SelectDate"), dbTable.getParentContainer() instanceof Dialog);
        this.setFormat(dateFormat);
        this.jt = jt;
        this.dbTable = dbTable;
        dbTable.setFnt(this);
        this.months = new String[]{dbTable.getString("January"), dbTable.getString("February"), dbTable.getString("March"), dbTable.getString("April"), dbTable.getString("May"), dbTable.getString("June"), dbTable.getString("July"), dbTable.getString("August"), dbTable.getString("September"), dbTable.getString("October"), dbTable.getString("November"), dbTable.getString("December")};
        this.weekdays = new String[]{dbTable.getString("Sunday"), dbTable.getString("Monday"), dbTable.getString("Tuesday"), dbTable.getString("Wednesday"), dbTable.getString("Thursday"), dbTable.getString("Friday"), dbTable.getString("Saturday")};
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(new LineBorder(Color.black));
        this.getContentPane().add(mainPanel);
        mainPanel.setLayout(new BorderLayout());
        this.monthNyear = new JPanel();
        this.monthNyear.setBackground(new Color(0, 55, 207));
        this.monthNyear.setForeground(Color.white);
        this.monthNyear.setBorder(new SoftBevelBorder(0));
        this.month = new JComboBox();
        this.month.setLightWeightPopupEnabled(false);
        int i = 0;
        while (i < 12) {
            this.month.addItem(this.months[i]);
            ++i;
        }
        this.month.addItemListener(this);
        dbTable.setFnt(this.month);
        this.year = new JTextField(4);
        this.year.addKeyListener(this);
        this.year.setDocument(new NumericDocument(4, -1, dbTable));
        this.monthNyear.add(this.month);
        this.monthNyear.add(this.year);
        this.hour = new JTextField(2);
        this.hour.setDocument(new NumericDocument(2, -1, dbTable));
        this.minute = new JTextField(2);
        this.minute.setDocument(new NumericDocument(2, -1, dbTable));
        this.am = new JComboBox();
        this.am.addItem("AM");
        this.am.addItem("PM");
        this.am.setLightWeightPopupEnabled(false);
        JLabel sepLabel = new JLabel(":");
        this.monthNyear.add(this.hour);
        this.monthNyear.add(sepLabel);
        this.monthNyear.add(this.minute);
        this.monthNyear.add(this.am);
        String pattern = dateFormat.toPattern();
        if (pattern != null && pattern.indexOf("h") < 0 && pattern.indexOf("H") < 0 && pattern.indexOf("k") < 0) {
            this.hour.setVisible(false);
            this.minute.setVisible(false);
            sepLabel.setVisible(false);
            this.am.setVisible(false);
        }
        mainPanel.add((Component)this.monthNyear, "North");
        this.days = new JPanel();
        dbTable.setFnt(this.days);
        this.days.setBackground(new Color(0, 159, 255));
        this.setBackground(new Color(0, 159, 255));
        this.days.setLayout(new GridLayout(0, 7));
        this.setFont(this.f);
        this.fm = this.getFontMetrics(this.f);
        this.cellsize = new Dimension(this.fm.charWidth('0') * 2 + this.pad * 3, this.fm.getHeight() + this.pad * 2);
        mainPanel.add((Component)this.days, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBackground(new Color(0, 55, 207));
        buttonPanel.setLayout(new FlowLayout(1));
        this.okButton = new JButton(dbTable.getString("Ok"));
        dbTable.setFnt(this.okButton);
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(dbTable.getString("Cancel"));
        dbTable.setFnt(this.cancelButton);
        this.cancelButton.addActionListener(this);
        this.clearButton = new JButton(dbTable.getString("Clear"));
        dbTable.setFnt(this.clearButton);
        this.clearButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.clearButton);
        mainPanel.add((Component)buttonPanel, "South");
        this.setSize(this.getPreferredSize());
    }

    public void setFormat(SimpleDateFormat dateFormat) {
        this.format = dateFormat;
    }

    public Date getDateLocal() {
        Calendar timeKeeper = Calendar.getInstance();
        timeKeeper.set(this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMinute());
        timeKeeper.set(9, this.getAM());
        return timeKeeper.getTime();
    }

    public Date getDate() {
        return this.returnDate;
    }

    public String getDateAsString() {
        return this.format.format(this.getDateLocal());
    }

    public void show(Component invoker, Date date, int x, int y, int row, int col) {
        this.oldDate = date;
        this.row = row;
        this.col = col;
        if (date == null) {
            this.setDate(new Date());
        } else {
            this.setDate(date);
        }
        this.arrangeDays();
        this.show(invoker, x, y);
        this.returnDate = date;
    }

    public void show(Component invoker, int x, int y) {
        if (invoker != null) {
            Point invokerOrigin = invoker.getLocationOnScreen();
            this.setLocation(invokerOrigin.x + x, invokerOrigin.y + y);
        } else {
            this.setLocation(x, y);
        }
        this.setVisible(true);
        this.cancelButton.requestFocus();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            if (this.oldDate != null) {
                this.returnDate = this.oldDate;
            }
        } else if (e.getSource() == this.clearButton) {
            this.jt.setText("");
            this.returnDate = null;
        } else {
            this.jt.setText(this.getDateAsString());
            this.returnDate = this.getDateLocal();
        }
        this.setVisible(false);
    }

    public void setDate(Date date) {
        Calendar timeKeeper = Calendar.getInstance();
        timeKeeper.setTime(date);
        this.setYear(timeKeeper.get(1));
        this.setMonth(timeKeeper.get(2));
        this.setDay(timeKeeper.get(5));
        this.setHour(timeKeeper.get(10));
        this.setMinute(timeKeeper.get(12));
        this.setAM(timeKeeper.get(9));
    }

    private int getYear() {
        if (this.year.getText() == null || "".equals(this.year.getText())) {
            return 0;
        }
        return Integer.parseInt(this.year.getText());
    }

    private void setYear(int newYear) {
        this.year.setText(Integer.toString(newYear));
    }

    private int getMonth() {
        return this.month.getSelectedIndex();
    }

    private void setMonth(int newMonth) {
        this.selectingMonth = true;
        this.month.setSelectedIndex(newMonth);
        this.selectingMonth = false;
    }

    private int getHour() {
        if (this.hour.getText() == null || "".equals(this.hour.getText())) {
            return 0;
        }
        int h = Integer.parseInt(this.hour.getText());
        if (h > 12) {
            return 12;
        }
        return h;
    }

    private void setHour(int newHour) {
        this.hour.setText(Integer.toString(newHour));
    }

    private int getMinute() {
        if (this.minute.getText() == null || "".equals(this.minute.getText())) {
            return 0;
        }
        int h = Integer.parseInt(this.minute.getText());
        if (h > 59) {
            return 59;
        }
        return h;
    }

    private void setMinute(int newMinute) {
        this.minute.setText(Integer.toString(newMinute));
    }

    private int getAM() {
        return this.am.getSelectedIndex();
    }

    private void setAM(int ip) {
        this.am.setSelectedIndex(ip);
    }

    private int getDay() {
        return this.currentDay;
    }

    private void setDay(int newDay) {
        this.currentDay = newDay;
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        this.arrangeDays();
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1 && this.isVisible() && !this.selectingMonth) {
            this.arrangeDays();
            this.setDateAndExit(this.getDay());
        }
    }

    protected void setDateAndExit(int newDay) {
        this.cells[this.currentDay - 1].deactivate();
        this.setDay(newDay);
        JTable table = this.dbTable.getTable();
        if (!table.isEditing()) {
            table.setValueAt(this.getDateLocal(), this.row, this.col);
        } else {
            this.jt.setText(this.getDateAsString());
        }
    }

    private void arrangeDays() {
        this.days.removeAll();
        int cMonth = this.getMonth();
        int cYear = this.getYear();
        Calendar timeKeeper = Calendar.getInstance();
        timeKeeper.set(cYear, cMonth, 1);
        timeKeeper.setTime(timeKeeper.getTime());
        int weekday = timeKeeper.get(7);
        int max = cMonth == 1 && timeKeeper instanceof GregorianCalendar && ((GregorianCalendar)timeKeeper).isLeapYear(cYear) ? 29 : this.monthLength[cMonth];
        if (this.currentDay > max) {
            this.currentDay = max;
        }
        int i = 0;
        while (i < 7) {
            this.days.add(new WeekdayCell(this.weekdays[i], this.cellsize, this));
            ++i;
        }
        i = 1;
        while (i < weekday) {
            this.days.add(new WeekdayCell("", this.cellsize, this));
            ++i;
        }
        this.cells = new DayCell[max];
        i = 0;
        while (i < max) {
            this.cells[i] = new DayCell(i + 1, this.cellsize, this);
            this.days.add(this.cells[i]);
            ++i;
        }
        this.cells[this.currentDay - 1].activate();
        this.pack();
    }

    void resetFont(Font fnt) {
        this.setFont(fnt);
        this.days.setFont(fnt);
        this.okButton.setFont(fnt);
        this.cancelButton.setFont(fnt);
        this.clearButton.setFont(fnt);
        this.month.setFont(fnt);
    }
}

