/*
 * Decompiled with CFR 0.152.
 */
package quick.dbtable;

import java.awt.Component;
import java.awt.Graphics;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.Document;
import quick.dbtable.CellComponent;
import quick.dbtable.DBTable;
import quick.dbtable.DBTableCellEditor;
import quick.dbtable.DBTableCellRenderer;
import quick.dbtable.DataMap;
import quick.dbtable.ResultSetMap;

public class Column
extends TableColumn
implements Serializable {
    public static final String READ_ONLY_PROPERTY = "readOnly";
    public static final String TYPE_PROPERTY = "type";
    public static final String COLUMN_NAME_PROPERTY = "columnName";
    public static final String SCALE_PROPERTY = "scale";
    public static final String PRECISION_PROPERTY = "precision";
    public static final String LENGTH_PROPERTY = "length";
    public static final String NULLABLE_PROPERTY = "nullable";
    public static final String SIGNED_PROPERTY = "signed";
    public static final String BOUND_SQL_PROPERTY = "boundSql";
    public static final String DATE_FORMAT_PROPERTY = "dateFormat";
    public static final String DOCUMENT_PROPERTY = "document";
    public static final String DATA_MAP_PROPERTY = "datamap";
    public static final String EDITOR_PROPERTY = "editor";
    public static final String RENDERER_PROPERTY = "renderer";
    public static final String VISIBLE_PROPERTY = "visible";
    public static final int IMAGE_CELL = 0;
    public static final int CHECKBOX_CELL = 1;
    public static final int RADIOBUTTON_CELL = 2;
    public static final int DEFAULT_CELL = 3;
    public static final int DATE_CELL = 4;
    public static final int COMBOBOX_CELL = 5;
    public static final int TEXTAREA_CELL = 6;
    public static final int USER_CELL = 7;
    private CellComponent cellEditorComponent;
    private CellComponent cellRendererComponent;
    private int oldWidth;
    private boolean isModifying = false;
    private static Icon emptyIcon;
    private boolean readOnly;
    private int type;
    private String columnName;
    private int scale;
    private int precision;
    private int length;
    private boolean nullable;
    private boolean signed;
    private String boundSql;
    private String dateFormat;
    private Document document;
    private DataMap dataMap;
    private ResultSetMap resultSetMap;
    private String methodName;
    private boolean virtualColumn = false;
    private boolean visible = true;
    private PropertyChangeSupport dbtableChangeSupport;

    public Column() {
    }

    public Column(int columnIndex) {
        super(columnIndex);
    }

    public Column(int columnIndex, int width) {
        super(columnIndex, width);
    }

    public Column(int columnIndex, String columnHeaderName) {
        super(columnIndex);
        this.setColumnName(columnHeaderName);
        this.setHeaderValue(columnHeaderName);
        DBTable.validateString(columnHeaderName, "Column(int columnIndex,String columnHeaderName)", "columnHeaderName");
    }

    public Column(int columnIndex, int width, TableCellRenderer cellRenderer, TableCellEditor cellEditor) {
        super(columnIndex, width, cellRenderer, cellEditor);
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean val) {
        this.readOnly = val;
        if (this.dbtableChangeSupport != null) {
            this.dbtableChangeSupport.firePropertyChange(READ_ONLY_PROPERTY, null, this);
        }
    }

    public DataMap getDataMap() {
        return this.dataMap;
    }

    public void setDataMap(DataMap val) {
        if (!DBTable.validateObject(val, "setDataMap(DataMap val)", "val")) {
            return;
        }
        this.dataMap = val;
        if (this.dbtableChangeSupport != null) {
            this.dbtableChangeSupport.firePropertyChange(DATA_MAP_PROPERTY, null, this);
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int val) {
        this.type = val;
        if (this.dbtableChangeSupport != null) {
            this.dbtableChangeSupport.firePropertyChange(TYPE_PROPERTY, null, this);
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String val) {
        DBTable.validateString(val, "setColumnName(String val)", "val");
        this.columnName = val;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int val) {
        this.scale = val;
        if (this.dbtableChangeSupport != null) {
            this.dbtableChangeSupport.firePropertyChange(SCALE_PROPERTY, null, this);
        }
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int val) {
        this.precision = val;
        if (this.dbtableChangeSupport != null) {
            this.dbtableChangeSupport.firePropertyChange(PRECISION_PROPERTY, null, this);
        }
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int val) {
        this.length = val;
        if (this.dbtableChangeSupport != null) {
            this.dbtableChangeSupport.firePropertyChange(LENGTH_PROPERTY, null, this);
        }
    }

    public boolean getNullable() {
        return this.nullable;
    }

    public void setNullable(boolean val) {
        this.nullable = val;
        if (this.dbtableChangeSupport != null) {
            this.dbtableChangeSupport.firePropertyChange(NULLABLE_PROPERTY, null, this);
        }
    }

    public boolean getSigned() {
        return this.signed;
    }

    public void setSigned(boolean val) {
        this.signed = val;
        if (this.dbtableChangeSupport != null) {
            this.dbtableChangeSupport.firePropertyChange(SIGNED_PROPERTY, null, this);
        }
    }

    public String getBoundSql() {
        return this.boundSql;
    }

    public void setBoundSql(String sql) {
        if (!DBTable.validateString(sql, "setBoundSql(String sql)", "sql")) {
            return;
        }
        this.boundSql = sql;
        if (this.dbtableChangeSupport != null) {
            this.dbtableChangeSupport.firePropertyChange(BOUND_SQL_PROPERTY, null, this);
        }
    }

    public void setDateFormat(String dateFormat) {
        if (!DBTable.validateString(dateFormat, "setDateFormat(String dateFormat)", DATE_FORMAT_PROPERTY)) {
            return;
        }
        this.dateFormat = dateFormat;
        if (this.dbtableChangeSupport != null) {
            this.dbtableChangeSupport.firePropertyChange(DATE_FORMAT_PROPERTY, null, this);
        }
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDocument(Document document) {
        if (!DBTable.validateObject(document, "setDocument(Document document)", DOCUMENT_PROPERTY)) {
            return;
        }
        this.document = document;
        if (this.dbtableChangeSupport != null) {
            this.dbtableChangeSupport.firePropertyChange(DOCUMENT_PROPERTY, null, this);
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public void refreshBoundCombo() {
        if (this.boundSql == null) {
            return;
        }
        if (this.dbtableChangeSupport != null) {
            this.dbtableChangeSupport.firePropertyChange(BOUND_SQL_PROPERTY, null, this);
        }
    }

    protected void setCellComponent(int cellType, Hashtable cellValueToDisplayHash, Object[] keysSortOrder, DBTable dBTable, boolean addClearOption) {
        DBTableCellRenderer dc = new DBTableCellRenderer(cellType, cellValueToDisplayHash, dBTable);
        this.setCellRenderer(dc);
        this.setCellEditor(new DBTableCellEditor(cellType, cellValueToDisplayHash, keysSortOrder, dBTable, addClearOption));
    }

    protected static Icon getEmptyIcon() {
        if (emptyIcon == null) {
            emptyIcon = new Icon(){

                public int getIconWidth() {
                    return 1;
                }

                public int getIconHeight() {
                    return 1;
                }

                public void paintIcon(Component c, Graphics g, int x, int y) {
                }
            };
        }
        return emptyIcon;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.dbtableChangeSupport == null) {
            this.dbtableChangeSupport = new PropertyChangeSupport(this);
        }
        this.dbtableChangeSupport.addPropertyChangeListener(listener);
        super.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.dbtableChangeSupport != null) {
            this.dbtableChangeSupport.removePropertyChangeListener(listener);
        }
        super.removePropertyChangeListener(listener);
    }

    public void setVisible(boolean val) {
        this.isModifying = true;
        if (val) {
            if (this.oldWidth == 0) {
                this.oldWidth = 15;
            }
            this.setMinWidth(this.oldWidth);
            this.setMaxWidth(Integer.MAX_VALUE);
            super.setPreferredWidth(this.oldWidth);
        } else {
            if (this.getWidth() != 0) {
                this.oldWidth = this.getWidth();
            }
            this.setMinWidth(0);
            this.setMaxWidth(0);
            super.setPreferredWidth(0);
        }
        if (this.dbtableChangeSupport != null) {
            this.dbtableChangeSupport.firePropertyChange(VISIBLE_PROPERTY, null, this);
        }
        this.isModifying = false;
        this.visible = val;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setPreferredWidth(int width) {
        if (width != 0 && !this.isModifying) {
            this.oldWidth = width;
        }
        super.setPreferredWidth(width);
    }

    public void setWidth(int width) {
        if (width != 0 && !this.isModifying) {
            this.oldWidth = width;
        }
        super.setWidth(width);
    }

    public void setUserCellEditor(CellComponent cc) {
        if (!DBTable.validateObject(cc, "setUserCellEditor(CellComponent cc)", "cc")) {
            return;
        }
        this.cellEditorComponent = cc;
        if (this.dbtableChangeSupport != null) {
            this.dbtableChangeSupport.firePropertyChange(EDITOR_PROPERTY, null, this);
        }
    }

    public CellComponent getUserCellEditor() {
        return this.cellEditorComponent;
    }

    public void setUserCellRenderer(CellComponent cc) {
        if (!DBTable.validateObject(cc, "setUserCellRenderer(CellComponent cc)", "cc")) {
            return;
        }
        this.cellRendererComponent = cc;
        if (this.dbtableChangeSupport != null) {
            this.dbtableChangeSupport.firePropertyChange(RENDERER_PROPERTY, null, this);
        }
    }

    public CellComponent getUserCellRenderer() {
        return this.cellRendererComponent;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        if (!DBTable.validateString(methodName, "setMethodName(String methodName)", "methodName")) {
            return;
        }
        this.methodName = methodName;
    }

    public void setResultSetMap(ResultSetMap val) {
        if (!DBTable.validateObject(val, "setResultSetMap(ResultSetMap val)", "val")) {
            return;
        }
        this.resultSetMap = val;
    }

    public ResultSetMap getResultSetMap() {
        return this.resultSetMap;
    }

    protected void setVirtual(boolean val) {
        this.virtualColumn = val;
    }

    protected boolean isVirtual() {
        return this.virtualColumn;
    }
}

