/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectUtils {
    public static List<String> DEFAULT_PACKAGES = new ArrayList<String>(2);

    public static int addMethods(Class aClass, List<Member> list) {
        Method[] methods;
        for (Method m : methods = aClass.getMethods()) {
            list.add(m);
        }
        return methods.length;
    }

    public static int addStaticMethods(Class aClass, List<Member> list) {
        Method[] methods;
        for (Method m : methods = aClass.getMethods()) {
            if (!Modifier.isStatic(m.getModifiers())) continue;
            list.add(m);
        }
        return methods.length;
    }

    public static int addStaticFields(Class aClass, List<Member> list) {
        Field[] fields;
        for (Field f : fields = aClass.getFields()) {
            if (!Modifier.isStatic(f.getModifiers())) continue;
            list.add(f);
        }
        return fields.length;
    }

    public static int addFields(Class aClass, List<Member> list) {
        Field[] fields;
        for (Field f : fields = aClass.getFields()) {
            list.add(f);
        }
        return fields.length;
    }

    public static int addConstrcutors(Class aClass, List<Member> list) {
        Constructor<?>[] constructors;
        for (Constructor<?> c : constructors = aClass.getConstructors()) {
            list.add(c);
        }
        return constructors.length;
    }

    public static String getJavaCallString(Constructor c) {
        StringBuilder call = new StringBuilder();
        call.append(c.getName());
        ReflectUtils.addParamsString(call, c.getParameterTypes());
        return call.toString();
    }

    public static String getJavaCallString(Method method) {
        StringBuilder call = new StringBuilder();
        call.append(method.getName());
        ReflectUtils.addParamsString(call, method.getParameterTypes());
        return call.toString();
    }

    public static StringBuilder addParamsString(StringBuilder call, Class[] params) {
        call.append("(");
        boolean firstArg = true;
        for (Class arg : params) {
            if (firstArg) {
                firstArg = false;
            } else {
                call.append(", ");
            }
            call.append(arg.getSimpleName());
        }
        call.append(")");
        return call;
    }

    public static String[] getMethodCalls(Class aClass) {
        String[] methods = new String[aClass.getMethods().length];
        int i = 0;
        for (Method method : aClass.getMethods()) {
            methods[i++] = ReflectUtils.getJavaCallString(method);
        }
        return methods;
    }

    public static String[] getConstructorCalls(Class aClass) {
        Constructor<?>[] constructors = aClass.getConstructors();
        String[] cons = new String[constructors.length];
        int i = 0;
        for (Constructor<?> c : constructors) {
            cons[i++] = ReflectUtils.getJavaCallString(c);
        }
        return cons;
    }

    public static String getParamsString(Class[] params) {
        StringBuilder sb = new StringBuilder();
        ReflectUtils.addParamsString(sb, params);
        return sb.toString();
    }

    private static Class[] getClasses(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        ArrayList<Class> classes = new ArrayList<Class>();
        for (File directory : dirs) {
            classes.addAll(ReflectUtils.findClasses(directory, packageName));
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static List<Class> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList<Class> classes = new ArrayList<Class>();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(ReflectUtils.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(Class.forName(packageName + '.' + file.getName().substring(0, file.getName().length() - 6)));
        }
        return classes;
    }

    public static Class findClass(String className, List<String> packages) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
        }
        catch (NoClassDefFoundError ex) {
            // empty catch block
        }
        for (String pack : packages) {
            try {
                return Class.forName(pack + "." + className);
            }
            catch (ClassNotFoundException ex) {
            }
            catch (NoClassDefFoundError ex) {
            }
        }
        return null;
    }

    static {
        DEFAULT_PACKAGES.add("java.lang");
        DEFAULT_PACKAGES.add("java.util");
        DEFAULT_PACKAGES.add("jsyntaxpane");
    }
}

