/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.components;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.gui.GotoLineDialog;
import jsyntaxpane.components.SyntaxComponent;
import jsyntaxpane.util.Configuration;

public class LineNumbersRuler
extends JComponent
implements SyntaxComponent,
PropertyChangeListener,
DocumentListener {
    public static final String PROPERTY_BACKGROUND = "LineNumbers.Background";
    public static final String PROPERTY_FOREGROUND = "LineNumbers.Foreground";
    public static final String PROPERTY_LEFT_MARGIN = "LineNumbers.LeftMargin";
    public static final String PROPERTY_RIGHT_MARGIN = "LineNumbers.RightMargin";
    public static final String PROPERTY_Y_OFFSET = "LineNumbers.YOFFset";
    public static final int DEFAULT_R_MARGIN = 5;
    public static final int DEFAULT_L_MARGIN = 5;
    public static final int DEFAULT_Y_OFFSET = -2;
    private JEditorPane pane;
    private String format;
    private int lineCount = -1;
    private int r_margin = 5;
    private int l_margin = 5;
    private int y_offset = -2;
    private int charHeight;
    private int charWidth;
    private MouseListener mouseListener = null;
    private Status status;

    protected void paintComponent(Graphics g) {
        g.setFont(this.pane.getFont());
        Rectangle clip = g.getClipBounds();
        g.setColor(this.getBackground());
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        g.setColor(this.getForeground());
        int lh = this.charHeight;
        int end = clip.y + clip.height + lh;
        int lineNum = clip.y / lh + 1;
        for (int y = clip.y / lh * lh + lh + this.y_offset; y <= end; y += lh) {
            String text = String.format(this.format, lineNum);
            g.drawString(text, this.l_margin, y);
            if (++lineNum > this.lineCount) break;
        }
    }

    private void updateSize() {
        int newLineCount = ActionUtils.getLineCount(this.pane);
        if (newLineCount == this.lineCount) {
            return;
        }
        this.lineCount = newLineCount;
        int h = this.lineCount * this.charHeight + this.pane.getHeight();
        int d = (int)Math.log10(this.lineCount) + 1;
        if (d < 1) {
            d = 1;
        }
        int w = d * this.charWidth + this.r_margin + this.l_margin;
        this.format = "%" + d + "d";
        this.setPreferredSize(new Dimension(w, h));
        this.getParent().doLayout();
    }

    public JScrollPane getScrollPane(JTextComponent editorPane) {
        for (Container p = editorPane.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof JScrollPane)) continue;
            return (JScrollPane)p;
        }
        return null;
    }

    public void config(Configuration config) {
        this.r_margin = config.getInteger(PROPERTY_RIGHT_MARGIN, 5);
        this.l_margin = config.getInteger(PROPERTY_LEFT_MARGIN, 5);
        this.y_offset = config.getInteger(PROPERTY_Y_OFFSET, -2);
        Color foreground = config.getColor(PROPERTY_FOREGROUND, Color.BLACK);
        this.setForeground(foreground);
        Color back = config.getColor(PROPERTY_BACKGROUND, Color.WHITE);
        this.setBackground(back);
    }

    public void install(JEditorPane editor) {
        this.pane = editor;
        this.charHeight = this.pane.getFontMetrics(this.pane.getFont()).getHeight();
        this.charWidth = this.pane.getFontMetrics(this.pane.getFont()).charWidth('0');
        editor.addPropertyChangeListener(this);
        JScrollPane sp = this.getScrollPane(this.pane);
        if (sp == null) {
            Logger.getLogger(this.getClass().getName()).warning("JEditorPane is not enclosed in JScrollPane, no LineNumbers will be displayed");
        } else {
            sp.setRowHeaderView(this);
            this.pane.getDocument().addDocumentListener(this);
            this.updateSize();
            this.mouseListener = new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    GotoLineDialog.showForEditor(LineNumbersRuler.this.pane);
                }
            };
            this.addMouseListener(this.mouseListener);
        }
        this.status = Status.INSTALLING;
    }

    public void deinstall(JEditorPane editor) {
        this.removeMouseListener(this.mouseListener);
        this.status = Status.DEINSTALLING;
        JScrollPane sp = this.getScrollPane(editor);
        if (sp != null) {
            editor.getDocument().removeDocumentListener(this);
            sp.setRowHeaderView(null);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("document")) {
            SyntaxDocument syntaxDocument;
            if (evt.getOldValue() instanceof SyntaxDocument) {
                syntaxDocument = (SyntaxDocument)evt.getOldValue();
                syntaxDocument.removeDocumentListener(this);
            }
            if (evt.getNewValue() instanceof SyntaxDocument && this.status.equals((Object)Status.INSTALLING)) {
                syntaxDocument = (SyntaxDocument)evt.getNewValue();
                syntaxDocument.addDocumentListener(this);
                this.updateSize();
            }
        } else if (evt.getPropertyName().equals("font")) {
            this.charHeight = this.pane.getFontMetrics(this.pane.getFont()).getHeight();
            this.charWidth = this.pane.getFontMetrics(this.pane.getFont()).charWidth('0');
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.updateSize();
    }

    public void removeUpdate(DocumentEvent e) {
        this.updateSize();
    }

    public void changedUpdate(DocumentEvent e) {
        this.updateSize();
    }

    public int getLeftMargin() {
        return this.l_margin;
    }

    public void setLeftMargin(int l_margin) {
        this.l_margin = l_margin;
    }

    public int getRightMargin() {
        return this.r_margin;
    }

    public void setRightMargin(int r_margin) {
        this.r_margin = r_margin;
    }

    public int getYOffset() {
        return this.y_offset;
    }

    public void setYOffset(int y_offset) {
        this.y_offset = y_offset;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Status {
        INSTALLING,
        DEINSTALLING;

    }
}

