/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.DocumentSearchData;
import jsyntaxpane.components.Markers;
import jsyntaxpane.util.SwingUtils;

public class ReplaceDialog
extends JDialog
implements CaretListener {
    private JTextComponent textComponent;
    private DocumentSearchData dsd;
    private static Markers.SimpleMarker SEARCH_MARKER = new Markers.SimpleMarker(Color.YELLOW);
    private JButton jBtnNext;
    private JButton jBtnReplaceAll;
    private JCheckBox jChkIgnoreCase;
    private JCheckBox jChkRegex;
    private JCheckBox jChkWrap;
    private JComboBox jCmbFind;
    private JComboBox jCmbReplace;
    private JLabel jLblFind;
    private JLabel jLblReplace;
    private JLabel jLblStatus;
    private JToggleButton jTglHighlight;

    public ReplaceDialog(JTextComponent text, DocumentSearchData dsd) {
        super(ActionUtils.getFrameFor(text), false);
        this.initComponents();
        this.textComponent = text;
        this.dsd = dsd;
        this.textComponent.addCaretListener(this);
        this.setLocationRelativeTo(text.getRootPane());
        this.getRootPane().setDefaultButton(this.jBtnNext);
        SwingUtils.addEscapeListener(this);
    }

    public void updateHighlights() {
        Markers.removeMarkers(this.textComponent, SEARCH_MARKER);
        if (this.jTglHighlight.isSelected()) {
            Markers.markAll(this.textComponent, this.dsd.getPattern(), SEARCH_MARKER);
        }
    }

    private void showRegexpError(PatternSyntaxException ex) throws HeadlessException {
        JOptionPane.showMessageDialog(this, "Regexp error: " + ex.getMessage(), "Regular Expression Error", 0);
        this.jCmbFind.requestFocus();
    }

    private void updateFinder() {
        String regex;
        int flag = 0;
        if (!this.jChkRegex.isSelected()) {
            flag |= 0x10;
        }
        flag |= this.jChkIgnoreCase.isSelected() ? 2 : 0;
        if (this.jChkIgnoreCase.isSelected()) {
            flag |= 2;
        }
        if ((regex = (String)this.jCmbFind.getSelectedItem()) != null && regex.length() > 0) {
            Pattern pattern = Pattern.compile(regex, flag);
            this.dsd.setWrap(this.jChkWrap.isSelected());
            this.dsd.setPattern(pattern);
            ActionUtils.insertIntoCombo(this.jCmbFind, regex);
        } else {
            this.dsd.setPattern(null);
        }
    }

    private void initComponents() {
        this.jLblFind = new JLabel();
        this.jCmbFind = new JComboBox();
        this.jBtnNext = new JButton();
        this.jLblReplace = new JLabel();
        this.jCmbReplace = new JComboBox();
        this.jBtnReplaceAll = new JButton();
        this.jChkIgnoreCase = new JCheckBox();
        this.jChkWrap = new JCheckBox();
        this.jTglHighlight = new JToggleButton();
        this.jChkRegex = new JCheckBox();
        this.jLblStatus = new JLabel();
        this.setTitle("Find and Replace");
        this.setName("");
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jLblFind.setHorizontalAlignment(11);
        this.jLblFind.setLabelFor(this.jCmbFind);
        this.jLblFind.setText("Find");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jLblFind, gridBagConstraints);
        this.jCmbFind.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        this.getContentPane().add((Component)this.jCmbFind, gridBagConstraints);
        this.jBtnNext.setMnemonic('N');
        this.jBtnNext.setText("Next");
        this.jBtnNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReplaceDialog.this.jBtnNextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        this.getContentPane().add((Component)this.jBtnNext, gridBagConstraints);
        this.jLblReplace.setHorizontalAlignment(11);
        this.jLblReplace.setLabelFor(this.jCmbReplace);
        this.jLblReplace.setText("Replace");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 9;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jLblReplace, gridBagConstraints);
        this.jCmbReplace.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        this.getContentPane().add((Component)this.jCmbReplace, gridBagConstraints);
        this.jBtnReplaceAll.setMnemonic('H');
        this.jBtnReplaceAll.setText("Replace All");
        this.jBtnReplaceAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReplaceDialog.this.jBtnReplaceAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        this.getContentPane().add((Component)this.jBtnReplaceAll, gridBagConstraints);
        this.jChkIgnoreCase.setMnemonic('I');
        this.jChkIgnoreCase.setText("Ignore Case");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jChkIgnoreCase, gridBagConstraints);
        this.jChkWrap.setMnemonic('W');
        this.jChkWrap.setText("Wrap around");
        this.jChkWrap.setToolTipText("Wrap to beginning when end is reached");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jChkWrap, gridBagConstraints);
        this.jTglHighlight.setText("Highlight");
        this.jTglHighlight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReplaceDialog.this.jTglHighlightActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        this.getContentPane().add((Component)this.jTglHighlight, gridBagConstraints);
        this.jChkRegex.setMnemonic('R');
        this.jChkRegex.setText("Regular Expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jChkRegex, gridBagConstraints);
        this.getContentPane().add((Component)this.jLblStatus, new GridBagConstraints());
        this.pack();
    }

    private void jBtnNextActionPerformed(ActionEvent evt) {
        try {
            this.updateFinder();
            this.dsd.doFindNext(this.textComponent);
            this.textComponent.requestFocusInWindow();
        }
        catch (PatternSyntaxException ex) {
            this.showRegexpError(ex);
        }
    }

    private void jBtnReplaceAllActionPerformed(ActionEvent evt) {
        try {
            this.updateFinder();
            String replacement = (String)this.jCmbReplace.getSelectedItem();
            ActionUtils.insertIntoCombo(this.jCmbFind, replacement);
            this.dsd.doReplaceAll(this.textComponent, replacement);
            this.textComponent.requestFocusInWindow();
        }
        catch (PatternSyntaxException ex) {
            this.showRegexpError(ex);
        }
    }

    private void jTglHighlightActionPerformed(ActionEvent evt) {
        this.updateFinder();
        this.updateHighlights();
    }

    public void caretUpdate(CaretEvent e) {
        this.updateHighlights();
    }
}

