/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.gui.MembersListRenderer;
import jsyntaxpane.util.ReflectUtils;
import jsyntaxpane.util.SwingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectCompletionDialog
extends JDialog {
    private Class theClass;
    public String escapeChars = ";(= \t\n";
    public List<Member> items;
    private final JTextComponent target;
    private JComboBox jCmbClassName;
    private JList jLstItems;
    private JScrollPane jScrollPane1;
    private JTextField jTxtItem;

    public ReflectCompletionDialog(JTextComponent target) {
        super(ActionUtils.getFrameFor(target), true);
        this.initComponents();
        this.target = target;
        this.jTxtItem.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                ReflectCompletionDialog.this.refilterList();
            }

            public void removeUpdate(DocumentEvent e) {
                ReflectCompletionDialog.this.refilterList();
            }

            public void changedUpdate(DocumentEvent e) {
                ReflectCompletionDialog.this.refilterList();
            }
        });
        this.jTxtItem.setFocusTraversalKeysEnabled(false);
        this.jCmbClassName.getEditor().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ReflectCompletionDialog.this.updateItems();
            }
        });
        SwingUtils.addEscapeListener(this);
    }

    public void setFonts(Font font) {
        this.jTxtItem.setFont(font);
        this.jLstItems.setFont(font);
        this.doLayout();
    }

    private void refilterList() {
        String prefix = this.jTxtItem.getText();
        Vector<Member> filtered = new Vector<Member>();
        Object selected = this.jLstItems.getSelectedValue();
        for (Member m : this.items) {
            if (!m.getName().startsWith(prefix)) continue;
            filtered.add(m);
        }
        this.jLstItems.setListData(filtered);
        if (selected != null) {
            this.jLstItems.setSelectedValue(selected, true);
        } else {
            this.jLstItems.setSelectedIndex(0);
        }
    }

    private void initComponents() {
        this.jTxtItem = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jLstItems = new JList();
        this.jCmbClassName = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.setName("CompletionDialog");
        this.setResizable(false);
        this.setUndecorated(true);
        this.jTxtItem.setBorder(null);
        this.jTxtItem.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                ReflectCompletionDialog.this.jTxtItemKeyPressed(evt);
            }
        });
        this.getContentPane().add((Component)this.jTxtItem, "First");
        this.jLstItems.setSelectionMode(0);
        this.jLstItems.setCellRenderer(new MembersListRenderer(this));
        this.jLstItems.setFocusable(false);
        this.jScrollPane1.setViewportView(this.jLstItems);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.jCmbClassName.setEditable(true);
        this.jCmbClassName.setModel(new DefaultComboBoxModel<String>(new String[]{"Object", "String"}));
        this.jCmbClassName.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ReflectCompletionDialog.this.jCmbClassNameItemStateChanged(evt);
            }
        });
        this.getContentPane().add((Component)this.jCmbClassName, "Last");
        this.pack();
    }

    private void jTxtItemKeyPressed(KeyEvent evt) {
        int i = this.jLstItems.getSelectedIndex();
        switch (evt.getKeyCode()) {
            case 27: {
                String result = this.jTxtItem.getText();
                ActionUtils.insertMagicString(this.target, result);
                this.setVisible(false);
                return;
            }
            case 40: {
                ++i;
                break;
            }
            case 38: {
                --i;
                break;
            }
            case 36: {
                i = 0;
                break;
            }
            case 35: {
                i = this.jLstItems.getModel().getSize() - 1;
                break;
            }
            case 34: {
                i += this.jLstItems.getVisibleRowCount();
                break;
            }
            case 33: {
                i -= this.jLstItems.getVisibleRowCount();
            }
        }
        if (this.escapeChars.indexOf(evt.getKeyChar()) >= 0) {
            Object selected;
            String result = this.jLstItems.getSelectedIndex() >= 0 ? ((selected = this.jLstItems.getSelectedValue()) instanceof Method ? ReflectUtils.getJavaCallString((Method)selected) : (selected instanceof Constructor ? ReflectUtils.getJavaCallString((Constructor)selected) : (selected instanceof Field ? ((Field)selected).getName() : selected.toString()))) : this.jTxtItem.getText();
            char pressed = evt.getKeyChar();
            if (pressed != '\n') {
                result = result + (pressed == '\t' ? (char)' ' : (char)pressed);
            }
            ActionUtils.insertMagicString(this.target, result);
            this.setVisible(false);
        } else {
            if (i >= this.jLstItems.getModel().getSize()) {
                i = this.jLstItems.getModel().getSize() - 1;
            }
            if (i < 0) {
                i = 0;
            }
            this.jLstItems.setSelectedIndex(i);
            this.jLstItems.ensureIndexIsVisible(i);
        }
    }

    private void jCmbClassNameItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.updateItems();
        }
    }

    private void updateItems() {
        String className = this.jCmbClassName.getEditor().getItem().toString();
        if (this.items == null) {
            this.items = new ArrayList<Member>();
        } else {
            this.items.clear();
        }
        Class aClass = ReflectUtils.findClass(className, ReflectUtils.DEFAULT_PACKAGES);
        if (aClass != null) {
            this.theClass = aClass;
            ReflectUtils.addConstrcutors(aClass, this.items);
            ReflectUtils.addMethods(aClass, this.items);
            ReflectUtils.addFields(aClass, this.items);
            ActionUtils.insertIntoCombo(this.jCmbClassName, className);
            this.jTxtItem.requestFocusInWindow();
        }
        this.refilterList();
    }

    public Class getTheClass() {
        return this.theClass;
    }

    public void setItems(List<Member> items) {
        this.items = items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayFor(JTextComponent target) {
        try {
            int dot = target.getCaretPosition();
            Window window = SwingUtilities.getWindowAncestor(target);
            Rectangle rt = target.modelToView(dot);
            Point loc = new Point(rt.x, rt.y);
            loc = SwingUtilities.convertPoint(target, loc, window);
            SwingUtilities.convertPointToScreen(loc, window);
            this.setLocationRelativeTo(window);
            this.setLocation(loc);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(ReflectCompletionDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            this.setFonts(target.getFont());
            this.updateItems();
            this.setVisible(true);
        }
    }
}

