/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions.gui;

import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import jsyntaxpane.actions.gui.ConstructorCell;
import jsyntaxpane.actions.gui.FieldCell;
import jsyntaxpane.actions.gui.MethodCell;
import jsyntaxpane.actions.gui.ReflectCompletionDialog;

class MembersListRenderer
extends DefaultListCellRenderer {
    static final Color evensColor = new Color(0xEEFFEE);
    private ReflectCompletionDialog dlg;

    public MembersListRenderer(ReflectCompletionDialog dlg) {
        this.dlg = dlg;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Color back;
        Color color = back = index % 2 == 1 ? list.getBackground() : evensColor;
        if (value instanceof Method) {
            Method method = (Method)value;
            return new MethodCell(list, isSelected, back, method, this.dlg.getTheClass());
        }
        if (value instanceof Field) {
            Field field = (Field)value;
            return new FieldCell(list, isSelected, back, field, this.dlg.getTheClass());
        }
        if (value instanceof Constructor) {
            Constructor cons = (Constructor)value;
            return new ConstructorCell(list, isSelected, back, cons, this.dlg.getTheClass());
        }
        Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        comp.setBackground(back);
        return comp;
    }
}

