/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions.gui;

import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class HTMLPreviewFrame
extends JFrame
implements DocumentListener {
    Document doc;
    private JEditorPane jEdtHtml;
    private JScrollPane jScrollPane1;

    public HTMLPreviewFrame(Document doc) {
        this.initComponents();
        this.doc = doc;
        doc.addDocumentListener(this);
        this.updateHTML();
    }

    private void updateHTML() {
        try {
            this.jEdtHtml.setText(this.doc.getText(0, this.doc.getLength()));
        }
        catch (BadLocationException ex) {
            Logger.getLogger(HTMLPreviewFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jEdtHtml = new JEditorPane();
        this.setDefaultCloseOperation(2);
        this.setTitle("HTML Preview");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                HTMLPreviewFrame.this.onWindowClosed(evt);
            }
        });
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 2));
        this.jEdtHtml.setContentType("text/html");
        this.jEdtHtml.setEditable(false);
        this.jEdtHtml.setPreferredSize(new Dimension(500, 250));
        this.jScrollPane1.setViewportView(this.jEdtHtml);
        this.getContentPane().add(this.jScrollPane1);
        this.pack();
    }

    private void onWindowClosed(WindowEvent evt) {
        this.doc.removeDocumentListener(this);
    }

    public void insertUpdate(DocumentEvent e) {
        this.updateHTML();
    }

    public void removeUpdate(DocumentEvent e) {
        this.updateHTML();
    }

    public void changedUpdate(DocumentEvent e) {
        this.updateHTML();
    }
}

