/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions.gui;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.text.JTextComponent;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.util.SwingUtils;

public class GotoLineDialog
extends JDialog {
    private static final String PROPERTY_KEY = "GOTOLINE_DIALOG";
    private JTextComponent text;
    private JButton jBtnOk;
    private JComboBox jCmbLineNumbers;

    private GotoLineDialog(JTextComponent text) {
        super(ActionUtils.getFrameFor(text), false);
        this.initComponents();
        this.text = text;
        this.setLocationRelativeTo(text.getRootPane());
        this.getRootPane().setDefaultButton(this.jBtnOk);
        text.getDocument().putProperty(PROPERTY_KEY, this);
        SwingUtils.addEscapeListener(this);
    }

    private void initComponents() {
        this.jCmbLineNumbers = new JComboBox();
        this.jBtnOk = new JButton();
        this.setTitle("Goto Line");
        this.setModal(true);
        this.setName("");
        this.setResizable(false);
        this.getContentPane().setLayout(new FlowLayout());
        this.jCmbLineNumbers.setEditable(true);
        this.jCmbLineNumbers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GotoLineDialog.this.jCmbLineNumbersActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.jCmbLineNumbers);
        this.jBtnOk.setAction(this.jCmbLineNumbers.getAction());
        this.jBtnOk.setText("Go");
        this.jBtnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GotoLineDialog.this.jBtnOkActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.jBtnOk);
        this.pack();
    }

    private void setTextPos() {
        Object line = this.jCmbLineNumbers.getSelectedItem();
        if (line != null) {
            try {
                int lineNr = Integer.parseInt(line.toString());
                ActionUtils.insertIntoCombo(this.jCmbLineNumbers, line);
                ActionUtils.setCaretPosition(this.text, lineNr, 0);
                this.setVisible(false);
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this, "Invalid Number: " + line, "Number Error", 0);
            }
        }
    }

    private void jCmbLineNumbersActionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("comboBoxEdited")) {
            this.setTextPos();
        }
    }

    private void jBtnOkActionPerformed(ActionEvent evt) {
        this.setTextPos();
    }

    public static void showForEditor(JTextComponent text) {
        GotoLineDialog dlg = null;
        dlg = text == null || text.getDocument().getProperty(PROPERTY_KEY) == null ? new GotoLineDialog(text) : (GotoLineDialog)text.getDocument().getProperty(PROPERTY_KEY);
        dlg.jCmbLineNumbers.requestFocusInWindow();
        dlg.setVisible(true);
    }
}

