/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions.gui;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboCompletionDialog
extends JDialog {
    private String result = null;
    public String escapeChars = ";(= \t\n";
    public List<String> items;
    private JList jLstItems;
    private JScrollPane jScrollPane1;
    private JTextField jTxtItem;

    public ComboCompletionDialog(Frame parent, boolean modal, List<String> items) {
        super(parent, modal);
        this.initComponents();
        this.items = items;
        this.jTxtItem.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                ComboCompletionDialog.this.refilterList();
            }

            public void removeUpdate(DocumentEvent e) {
                ComboCompletionDialog.this.refilterList();
            }

            public void changedUpdate(DocumentEvent e) {
                ComboCompletionDialog.this.refilterList();
            }
        });
        this.refilterList();
        this.jTxtItem.setFocusTraversalKeysEnabled(false);
    }

    public void setFonts(Font font) {
        this.jTxtItem.setFont(font);
        this.jLstItems.setFont(font);
        this.doLayout();
    }

    public void setText(String abbrev) {
        this.jTxtItem.setText(abbrev);
    }

    private void refilterList() {
        String prefix = this.jTxtItem.getText();
        Vector<String> filtered = new Vector<String>();
        Object selected = this.jLstItems.getSelectedValue();
        for (String s : this.items) {
            if (!s.startsWith(prefix)) continue;
            filtered.add(s);
        }
        this.jLstItems.setListData(filtered);
        if (selected != null) {
            this.jLstItems.setSelectedValue(selected, true);
        } else {
            this.jLstItems.setSelectedIndex(0);
        }
    }

    private void initComponents() {
        this.jTxtItem = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jLstItems = new JList();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setUndecorated(true);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.jTxtItem.setBorder(null);
        this.jTxtItem.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                ComboCompletionDialog.this.jTxtItemKeyPressed(evt);
            }
        });
        this.getContentPane().add(this.jTxtItem);
        this.jLstItems.setSelectionMode(0);
        this.jLstItems.setFocusable(false);
        this.jScrollPane1.setViewportView(this.jLstItems);
        this.getContentPane().add(this.jScrollPane1);
        this.pack();
    }

    private void jTxtItemKeyPressed(KeyEvent evt) {
        int i = this.jLstItems.getSelectedIndex();
        switch (evt.getKeyCode()) {
            case 27: {
                this.result = this.jTxtItem.getText();
                this.setVisible(false);
                return;
            }
            case 40: {
                if (i < this.jLstItems.getModel().getSize() - 1) {
                    ++i;
                }
                this.jLstItems.setSelectedIndex(i);
                this.jLstItems.ensureIndexIsVisible(i);
                break;
            }
            case 38: {
                if (i > 0) {
                    --i;
                }
                this.jLstItems.setSelectedIndex(i);
                this.jLstItems.ensureIndexIsVisible(i);
            }
        }
        if (this.escapeChars.indexOf(evt.getKeyChar()) >= 0) {
            this.result = this.jLstItems.getSelectedIndex() >= 0 ? this.jLstItems.getSelectedValue().toString() : this.jTxtItem.getText();
            char pressed = evt.getKeyChar();
            if (pressed != '\n') {
                this.result = this.result + (pressed == '\t' ? (char)' ' : (char)pressed);
            }
            this.setVisible(false);
        }
    }

    public String getResult() {
        return this.result == null ? "" : this.result;
    }
}

