/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.DefaultSyntaxAction;
import jsyntaxpane.util.Configuration;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlPrettifyAction
extends DefaultSyntaxAction {
    static Transformer transformer;
    static DocumentBuilder docBuilder;

    public XmlPrettifyAction() {
        super("XML_PRETTIFY");
    }

    public void actionPerformed(ActionEvent e) {
        if (transformer == null) {
            return;
        }
        JTextComponent target = this.getTextComponent(e);
        try {
            SyntaxDocument sdoc = ActionUtils.getSyntaxDocument(target);
            StringWriter out = new StringWriter(sdoc.getLength());
            StringReader reader = new StringReader(target.getText());
            InputSource src = new InputSource(reader);
            Document doc = docBuilder.parse(src);
            transformer.transform(new DOMSource(doc), new StreamResult(out));
            target.read(new StringReader(out.toString()), null);
        }
        catch (SAXParseException ex) {
            XmlPrettifyAction.showErrorMessage(target, String.format("XML error: %s\nat(%d, %d)", ex.getMessage(), ex.getLineNumber(), ex.getColumnNumber()));
            ActionUtils.setCaretPosition(target, ex.getLineNumber(), ex.getColumnNumber() - 1);
        }
        catch (TransformerException ex) {
            XmlPrettifyAction.showErrorMessage(target, ex.getMessageAndLocation());
        }
        catch (SAXException ex) {
            XmlPrettifyAction.showErrorMessage(target, ex.getLocalizedMessage());
        }
        catch (IOException ex) {
            XmlPrettifyAction.showErrorMessage(target, ex.getLocalizedMessage());
        }
    }

    private static void showErrorMessage(JTextComponent text, String msg) {
        Window parent = SwingUtilities.getWindowAncestor(text);
        JOptionPane.showMessageDialog(parent, msg, "JsyntaxPAne XML", 0);
    }

    public void config(Configuration config, String name) {
        try {
            TransformerFactory tfactory = TransformerFactory.newInstance();
            transformer = tfactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("standalone", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setIgnoringElementContentWhitespace(true);
            docBuilder = docBuilderFactory.newDocumentBuilder();
        }
        catch (TransformerConfigurationException ex) {
            Logger.getLogger(XmlPrettifyAction.class.getName()).log(Level.SEVERE, null, ex);
            transformer = null;
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(XmlPrettifyAction.class.getName()).log(Level.SEVERE, null, ex);
            transformer = null;
        }
    }
}

