/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.event.ActionEvent;
import javax.swing.text.JTextComponent;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.DefaultSyntaxAction;
import jsyntaxpane.util.Configuration;

public class SurroundWithAction
extends DefaultSyntaxAction {
    private boolean indent = true;
    private String prefix = "";
    private String postfix = "";

    public SurroundWithAction() {
        super("SURROUND_ACTION");
    }

    public void actionPerformed(JTextComponent target, SyntaxDocument sDoc, int dot, ActionEvent e) {
        String[] selection = ActionUtils.getSelectedLines(target);
        String lineIndent = selection.length == 0 ? "" : ActionUtils.getIndent(selection[0]);
        StringBuilder repl = new StringBuilder();
        this.appendWithIndent(repl, this.getPrefix(), lineIndent);
        String tab = ActionUtils.getTab(target);
        for (String line : selection) {
            if (this.indent) {
                repl.append(tab);
            }
            repl.append(line);
            repl.append("\n");
        }
        this.appendWithIndent(repl, this.getPostfix(), lineIndent);
        target.replaceSelection(repl.toString());
    }

    public void config(Configuration config, String name) {
        this.prefix = config.getString(name + ".prefix", "");
        this.postfix = config.getString(name + ".postfix", "");
        this.indent = config.getBoolean(name + ".indent", true);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getPostfix() {
        return this.postfix;
    }

    void appendWithIndent(StringBuilder sb, String lines, String indent) {
        sb.append(indent);
        for (int i = 0; i < lines.length(); ++i) {
            sb.append(lines.charAt(i));
            if (lines.charAt(i) != '\n' || i >= lines.length() - 1) continue;
            sb.append(indent);
        }
    }
}

