/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.event.ActionEvent;
import javax.swing.text.JTextComponent;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.Token;
import jsyntaxpane.TokenType;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.DefaultSyntaxAction;

public class JIndentAction
extends DefaultSyntaxAction {
    public JIndentAction() {
        super("JINDENT");
    }

    public void actionPerformed(JTextComponent target, SyntaxDocument sDoc, int dot, ActionEvent e) {
        int pos = target.getCaretPosition();
        int start = sDoc.getParagraphElement(pos).getStartOffset();
        String line = ActionUtils.getLine(target);
        String lineToPos = line.substring(0, pos - start);
        String prefix = ActionUtils.getIndent(line);
        Token t = sDoc.getTokenAt(pos);
        if (TokenType.isComment(t)) {
            if (line.trim().endsWith("*/")) {
                prefix = prefix.substring(0, prefix.length() - 1);
            } else if (line.trim().startsWith("*")) {
                prefix = prefix + "* ";
            } else if (line.trim().startsWith("/*")) {
                prefix = prefix + " * ";
            }
        } else if (lineToPos.trim().endsWith("{")) {
            prefix = prefix + ActionUtils.getTab(target);
        } else {
            String noComment = sDoc.getUncommentedText(start, pos);
            if (noComment.trim().endsWith("{")) {
                prefix = prefix + ActionUtils.getTab(target);
            }
        }
        target.replaceSelection("\n" + prefix);
    }
}

