/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.event.ActionEvent;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.DefaultSyntaxAction;

public class IndentAction
extends DefaultSyntaxAction {
    public IndentAction() {
        super("INSERT_TAB");
    }

    public void actionPerformed(JTextComponent target, SyntaxDocument sDoc, int dot, ActionEvent e) {
        String selected = target.getSelectedText();
        if (selected == null) {
            PlainDocument pDoc = (PlainDocument)target.getDocument();
            Integer tabStop = (Integer)pDoc.getProperty("tabSize");
            int lineStart = pDoc.getParagraphElement(target.getCaretPosition()).getStartOffset();
            int column = target.getCaretPosition() - lineStart;
            int needed = tabStop - column % tabStop;
            target.replaceSelection("                ".substring(0, needed));
        } else {
            String[] lines = ActionUtils.getSelectedLines(target);
            int start = target.getSelectionStart();
            StringBuilder sb = new StringBuilder();
            for (String line : lines) {
                sb.append('\t');
                sb.append(line);
                sb.append('\n');
            }
            target.replaceSelection(sb.toString());
            target.select(start, start + sb.length());
        }
    }
}

