/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.Component;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.gui.ReplaceDialog;

public class DocumentSearchData {
    private static final String PROPERTY_KEY = "SearchData";
    private Pattern pattern = null;
    private boolean wrap = true;
    private ReplaceDialog dlg;

    private DocumentSearchData() {
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public void setWrap(boolean wrap) {
        this.wrap = wrap;
    }

    public static DocumentSearchData getFromEditor(JTextComponent target) {
        if (target == null) {
            return null;
        }
        Object o = target.getDocument().getProperty(PROPERTY_KEY);
        if (o instanceof DocumentSearchData) {
            DocumentSearchData documentSearchData = (DocumentSearchData)o;
            return documentSearchData;
        }
        DocumentSearchData newDSD = new DocumentSearchData();
        target.getDocument().putProperty(PROPERTY_KEY, newDSD);
        return newDSD;
    }

    public void doReplaceAll(JTextComponent target, String replacement) {
        SyntaxDocument sDoc = ActionUtils.getSyntaxDocument(target);
        if (sDoc == null) {
            return;
        }
        if (this.getPattern() == null) {
            return;
        }
        Matcher matcher = sDoc.getMatcher(this.getPattern());
        String newText = matcher.replaceAll(replacement);
        target.setText(newText);
    }

    public void doFindNext(JTextComponent target) {
        Matcher matcher;
        if (this.getPattern() == null) {
            return;
        }
        SyntaxDocument sDoc = ActionUtils.getSyntaxDocument(target);
        if (sDoc == null) {
            return;
        }
        int start = target.getCaretPosition() + 1;
        if (start >= sDoc.getLength()) {
            start = 0;
        }
        if ((matcher = sDoc.getMatcher(this.getPattern(), start)) != null && matcher.find()) {
            target.select(matcher.start() + start, matcher.end() + start);
        } else if (this.isWrap()) {
            matcher = sDoc.getMatcher(this.getPattern());
            if (matcher != null && matcher.find()) {
                target.select(matcher.start(), matcher.end());
            } else {
                this.msgNotFound(target);
            }
        } else {
            this.msgNotFound(target);
        }
    }

    public void msgNotFound(Component target) {
        JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(target), "Search String " + this.getPattern() + " not found", "Find", 1);
    }

    public void showDialog(JTextComponent target) {
        if (this.dlg == null) {
            this.dlg = new ReplaceDialog(target, this);
        }
        this.dlg.setVisible(true);
    }
}

