/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.Token;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.DefaultSyntaxAction;
import jsyntaxpane.actions.gui.ComboCompletionDialog;
import jsyntaxpane.util.Configuration;
import jsyntaxpane.util.JarServiceProvider;

public class ComboCompletionAction
extends DefaultSyntaxAction {
    Map<String, String> completions;
    ComboCompletionDialog dlg;
    private List<String> items;

    public ComboCompletionAction() {
        super("COMBO_COMPLETION");
    }

    public void actionPerformed(JTextComponent target, SyntaxDocument sdoc, int dot, ActionEvent e) {
        if (sdoc == null) {
            return;
        }
        Token token = sdoc.getTokenAt(dot);
        String abbrev = "";
        try {
            if (token != null) {
                abbrev = ((Object)token.getText(sdoc)).toString();
                sdoc.remove(token.start, token.length);
                dot = token.start;
            }
            Window window = SwingUtilities.getWindowAncestor(target);
            if (this.dlg == null) {
                if (window instanceof Frame) {
                    Frame frame = (Frame)window;
                    this.dlg = new ComboCompletionDialog(frame, true, this.items);
                } else {
                    this.dlg = new ComboCompletionDialog(null, true, this.items);
                }
            }
            this.dlg.setLocationRelativeTo(window);
            Point p = window.getLocation();
            Rectangle rt = target.modelToView(dot);
            Point loc = new Point(rt.x, rt.y);
            loc = SwingUtilities.convertPoint(target, loc, window);
            SwingUtilities.convertPointToScreen(loc, window);
            this.dlg.setLocation(loc);
            this.dlg.setFonts(target.getFont());
            this.dlg.setText(abbrev);
            this.dlg.setVisible(true);
            String res = this.dlg.getResult();
            ActionUtils.insertMagicString(target, dot, res);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(ComboCompletionAction.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void config(Configuration config, String name) {
        String itemsUrl = config.getString(name + ".Items.URL");
        this.items = JarServiceProvider.readLines(itemsUrl);
    }

    public TextAction getAction(String key) {
        return this;
    }
}

