/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import javax.swing.JLabel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.actions.ActionUtils;

public class CaretMonitor
implements CaretListener {
    private JLabel label;
    private JTextComponent text;
    private String noSelectionFormat = "%d:%d (%d)";
    private String selectionFormat = "%d:%d - %d:%d (%d)";

    public CaretMonitor(JTextComponent text, JLabel label) {
        this.label = label;
        this.text = text;
        text.addCaretListener(this);
    }

    public void caretUpdate(CaretEvent evt) {
        block5: {
            if (this.text.getDocument() instanceof SyntaxDocument) {
                try {
                    if (this.text.getSelectionStart() == this.text.getSelectionEnd()) {
                        int pos = evt.getDot();
                        String loc = String.format(this.noSelectionFormat, ActionUtils.getLineNumber(this.text, pos) + 1, ActionUtils.getColumnNumber(this.text, pos) + 1, pos);
                        this.label.setText(loc);
                        break block5;
                    }
                    int start = this.text.getSelectionStart();
                    int end = this.text.getSelectionEnd();
                    String loc = String.format(this.selectionFormat, ActionUtils.getLineNumber(this.text, start) + 1, ActionUtils.getColumnNumber(this.text, start) + 1, ActionUtils.getLineNumber(this.text, end) + 1, ActionUtils.getColumnNumber(this.text, end) + 1, end - start, start, end);
                    this.label.setText(loc);
                }
                catch (BadLocationException ex) {
                    this.label.setText("Ex: " + ex.getMessage());
                }
            } else {
                this.label.setText("Position");
            }
        }
    }

    protected void finalize() throws Throwable {
        this.text.removeCaretListener(this);
        super.finalize();
    }

    public String getNoSelectionFormat() {
        return this.noSelectionFormat;
    }

    public void setNoSelectionFormat(String noSelectionFormat) {
        this.noSelectionFormat = noSelectionFormat;
    }

    public String getSelectionFormat() {
        return this.selectionFormat;
    }

    public void setSelectionFormat(String selectionFormat) {
        this.selectionFormat = selectionFormat;
    }
}

