/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import jsyntaxpane.TokenType;

public class Token
implements Serializable,
Comparable {
    public final TokenType type;
    public final int start;
    public final int length;
    public final byte pairValue;
    public final short kind = 0;
    public static final short EQ = 1;
    public static final short GT = 2;
    public static final short LT = 3;
    public static final short NOT = 4;
    public static final short COMP = 5;
    public static final short QUESTION = 6;
    public static final short COLON = 7;
    public static final short EQEQ = 8;
    public static final short LTEQ = 9;
    public static final short GTEQ = 10;
    public static final short NOTEQ = 11;
    public static final short ANDAND = 12;
    public static final short OROR = 13;
    public static final short PLUSPLUS = 14;
    public static final short MINUSMINUS = 15;
    public static final short PLUS = 16;
    public static final short MINUS = 17;
    public static final short MULT = 18;
    public static final short DIV = 19;
    public static final short AND = 20;
    public static final short OR = 21;
    public static final short XOR = 22;
    public static final short MOD = 23;
    public static final short LSHIFT = 24;
    public static final short RSHIFT = 25;
    public static final short URSHIFT = 26;
    public static final short PLUSEQ = 27;
    public static final short MINUSEQ = 28;
    public static final short MULTEQ = 29;
    public static final short DIVEQ = 30;
    public static final short ANDEQ = 31;
    public static final short OREQ = 32;
    public static final short XOREQ = 33;
    public static final short MODEQ = 34;
    public static final short LSHIFTEQ = 35;
    public static final short RSHIFTEQ = 36;
    public static final short URSHIFTEQ = 37;
    public static final short LPAREN = 38;
    public static final short RPAREN = 39;
    public static final short LBRACE = 40;
    public static final short RBRACE = 41;
    public static final short LBRACK = 42;
    public static final short RBRACK = 43;
    public static final short SEMICOLON = 44;
    public static final short COMMA = 46;
    public static final short DOT = 47;
    public static final short KW_START = 255;
    public static final short KW_abstract = 255;
    public static final short KW_assert = 256;
    public static final short KW_boolean = 257;
    public static final short KW_break = 258;
    public static final short KW_byte = 259;
    public static final short KW_case = 260;
    public static final short KW_catch = 261;
    public static final short KW_char = 262;
    public static final short KW_class = 263;
    public static final short KW_const = 264;
    public static final short KW_continue = 265;
    public static final short KW_do = 266;
    public static final short KW_double = 267;
    public static final short KW_else = 268;
    public static final short KW_extends = 269;
    public static final short KW_final = 270;
    public static final short KW_finally = 271;
    public static final short KW_float = 272;
    public static final short KW_for = 273;
    public static final short KW_default = 274;
    public static final short KW_implements = 275;
    public static final short KW_import = 276;
    public static final short KW_instanceof = 277;
    public static final short KW_int = 278;
    public static final short KW_interface = 279;
    public static final short KW_long = 280;
    public static final short KW_native = 281;
    public static final short KW_new = 282;
    public static final short KW_goto = 283;
    public static final short KW_if = 284;
    public static final short KW_public = 285;
    public static final short KW_short = 286;
    public static final short KW_super = 287;
    public static final short KW_switch = 288;
    public static final short KW_synchronized = 289;
    public static final short KW_package = 290;
    public static final short KW_private = 291;
    public static final short KW_protected = 292;
    public static final short KW_transient = 293;
    public static final short KW_return = 294;
    public static final short KW_void = 295;
    public static final short KW_static = 296;
    public static final short KW_while = 297;
    public static final short KW_this = 298;
    public static final short KW_throw = 299;
    public static final short KW_throws = 300;
    public static final short KW_try = 301;
    public static final short KW_volatile = 302;
    public static final short KW_strictfp = 303;

    public Token(TokenType type, int start, int length) {
        this.type = type;
        this.start = start;
        this.length = length;
        this.pairValue = 0;
    }

    public Token(TokenType type, int start, int length, byte pairValue) {
        this.type = type;
        this.start = start;
        this.length = length;
        this.pairValue = pairValue;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Object) {
            Token token = (Token)obj;
            return this.start == token.start && this.length == token.length && this.type.equals((Object)token.type);
        }
        return false;
    }

    public int hashCode() {
        return this.start;
    }

    public String toString() {
        if (this.pairValue == 0) {
            return String.format("%s (%d, %d)", new Object[]{this.type, this.start, this.length});
        }
        return String.format("%s (%d, %d) (%d)", new Object[]{this.type, this.start, this.length, this.pairValue});
    }

    public int compareTo(Object o) {
        Token t = (Token)o;
        if (this.start != t.start) {
            return this.start - t.start;
        }
        if (this.length != t.length) {
            return this.length - t.length;
        }
        return this.type.compareTo(t.type);
    }

    public int end() {
        return this.start + this.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharSequence getText(Document doc) {
        Segment text = new Segment();
        try {
            doc.getText(this.start, this.length, text);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(Token.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            return text.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(Document doc) {
        String result = "";
        try {
            result = doc.getText(this.start, this.length);
            return result;
        }
        catch (BadLocationException ex) {
            Logger.getLogger(Token.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            return result;
        }
    }
}

