/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import jsyntaxpane.DefaultSyntaxKit;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.Token;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.CaretMonitor;

public class SyntaxTester
extends JFrame {
    private JComboBox jCmbLangs;
    private JEditorPane jEdtTest;
    private JScrollPane jScrollPane1;
    private JLabel lblCaretPos;
    private JLabel lblToken;

    public SyntaxTester() {
        DefaultSyntaxKit.registerContentType("text/aa_regex", "jsyntaxpane.JavaRegexKit");
        this.initComponents();
        this.jCmbLangs.setModel(new DefaultComboBoxModel<String>(DefaultSyntaxKit.getContentTypes()));
        this.jCmbLangs.setSelectedItem("text/java");
        new CaretMonitor(this.jEdtTest, this.lblCaretPos);
    }

    private void initComponents() {
        this.lblCaretPos = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jEdtTest = new JEditorPane();
        this.lblToken = new JLabel();
        this.jCmbLangs = new JComboBox();
        this.setDefaultCloseOperation(3);
        this.setTitle("JSyntaxPane Tester");
        this.getContentPane().setLayout(new GridBagLayout());
        this.lblCaretPos.setHorizontalAlignment(11);
        this.lblCaretPos.setText("Caret Position");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.weightx = 3.0;
        this.getContentPane().add((Component)this.lblCaretPos, gridBagConstraints);
        this.jEdtTest.setContentType("");
        this.jEdtTest.setFont(new Font("Monospaced", 0, 13));
        this.jEdtTest.setCaretColor(new Color(153, 204, 255));
        this.jEdtTest.setPreferredSize(new Dimension(800, 600));
        this.jEdtTest.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent evt) {
                SyntaxTester.this.jEdtTestCaretUpdate(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jEdtTest);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.weighty = 10.0;
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.lblToken.setFont(new Font("Courier New", 0, 12));
        this.lblToken.setText("Token under cursor");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        this.getContentPane().add((Component)this.lblToken, gridBagConstraints);
        this.jCmbLangs.setMaximumRowCount(20);
        this.jCmbLangs.setFocusable(false);
        this.jCmbLangs.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SyntaxTester.this.jCmbLangsItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.weightx = 7.0;
        this.getContentPane().add((Component)this.jCmbLangs, gridBagConstraints);
        this.pack();
    }

    private void jEdtTestCaretUpdate(CaretEvent evt) {
        SyntaxDocument sDoc = ActionUtils.getSyntaxDocument(this.jEdtTest);
        if (sDoc != null) {
            Token t = sDoc.getTokenAt(evt.getDot());
            if (t != null) {
                CharSequence tData = t.getText(sDoc);
                if (t.length > 40) {
                    tData = tData.subSequence(0, 40);
                }
                this.lblToken.setText(t.toString() + ": " + tData);
            } else {
                this.lblToken.setText("NO Token at cursor");
            }
        }
    }

    private void jCmbLangsItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            String lang = this.jCmbLangs.getSelectedItem().toString();
            String oldText = this.jEdtTest.getText();
            this.jEdtTest.setContentType(lang);
            try {
                this.jEdtTest.read(new StringReader(oldText), (Object)lang);
            }
            catch (IOException ex) {
                Logger.getLogger(SyntaxTester.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    DefaultSyntaxKit.initKit();
                    new SyntaxTester().setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(2);
                }
            }
        });
    }
}

