/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import jsyntaxpane.Lexer;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.SyntaxView;
import jsyntaxpane.actions.SyntaxAction;
import jsyntaxpane.components.SyntaxComponent;
import jsyntaxpane.util.Configuration;
import jsyntaxpane.util.JarServiceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSyntaxKit
extends DefaultEditorKit
implements ViewFactory {
    public static final String CONFIG_CARETCOLOR = "CaretColor";
    public static final String CONFIG_SELECTION = "SelectionColor";
    public static final String CONFIG_COMPONENTS = "Components";
    public static final String CONFIG_MENU = "PopupMenu";
    public static final String CONFIG_MENU_ICONS = "PopupMenuIcons";
    public static final String PROPERTY_KEYMAP_JSYNTAXPANE = "jsyntaxpane";
    public static final Pattern EQUALS_REGEX = Pattern.compile("\\s*=\\s*");
    private static final Pattern ACTION_KEY_PATTERN = Pattern.compile("Action\\.(\\w+)");
    private static Font DEFAULT_FONT;
    private static Set<String> CONTENT_TYPES;
    private static Boolean initialized;
    private Lexer lexer;
    private static final Logger LOG;
    private Map<JEditorPane, List<SyntaxComponent>> editorComponents = new WeakHashMap<JEditorPane, List<SyntaxComponent>>();
    private Map<JEditorPane, JPopupMenu> popupMenu = new WeakHashMap<JEditorPane, JPopupMenu>();
    private static Map<Class<? extends DefaultSyntaxKit>, Configuration> CONFIGS;

    public DefaultSyntaxKit(Lexer lexer) {
        this.lexer = lexer;
    }

    public void addComponents(JEditorPane editorPane) {
        String[] components;
        for (String c : components = this.getConfig().getPropertyList(CONFIG_COMPONENTS)) {
            this.installComponent(editorPane, c);
        }
    }

    public void installComponent(JEditorPane pane, String classname) {
        try {
            Class<?> compClass = Class.forName(classname);
            SyntaxComponent comp = (SyntaxComponent)compClass.newInstance();
            comp.config(this.getConfig());
            comp.install(pane);
            if (this.editorComponents.get(pane) == null) {
                this.editorComponents.put(pane, new ArrayList());
            }
            this.editorComponents.get(pane).add(comp);
        }
        catch (InstantiationException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        catch (ClassNotFoundException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public void deinstallComponent(JEditorPane pane, String classname) {
        for (SyntaxComponent c : this.editorComponents.get(pane)) {
            if (!c.getClass().getName().equals(classname)) continue;
            c.deinstall(pane);
            this.editorComponents.remove(c);
            break;
        }
    }

    public boolean isComponentInstalled(JEditorPane pane, String classname) {
        for (SyntaxComponent c : this.editorComponents.get(pane)) {
            if (!c.getClass().getName().equals(classname)) continue;
            return true;
        }
        return false;
    }

    public boolean toggleComponent(JEditorPane pane, String classname) {
        for (SyntaxComponent c : this.editorComponents.get(pane)) {
            if (!c.getClass().getName().equals(classname)) continue;
            c.deinstall(pane);
            this.editorComponents.get(pane).remove(c);
            return false;
        }
        this.installComponent(pane, classname);
        return true;
    }

    public void addPopupMenu(JEditorPane editorPane) {
        String[] menuItems = this.getConfig().getPropertyList(CONFIG_MENU);
        if (menuItems == null || menuItems.length == 0) {
            return;
        }
        this.popupMenu.put(editorPane, new JPopupMenu());
        String menuIconsLocation = this.getConfig().getString(CONFIG_MENU_ICONS, "/META-INF/images/");
        Component stack = null;
        for (String menu : menuItems) {
            String[] menudata = EQUALS_REGEX.split(menu);
            String menuText = menudata[0];
            if (menuText.equals("-")) {
                this.popupMenu.get(editorPane).addSeparator();
                continue;
            }
            if (menuText.startsWith(">")) {
                JMenu sub = new JMenu(menuText.substring(1));
                this.popupMenu.get(editorPane).add(sub);
                stack = sub;
                continue;
            }
            if (menuText.startsWith("<")) {
                Container parent = stack.getParent();
                if (parent instanceof JMenu) {
                    JMenu jMenu = (JMenu)parent;
                    stack = jMenu;
                    continue;
                }
                stack = null;
                continue;
            }
            JMenuItem menuItem = new JMenuItem();
            if (menudata.length < 2) {
                throw new IllegalArgumentException("Invalid menu item data: " + menu);
            }
            String menuAction = menudata[1].trim();
            Action action = editorPane.getActionMap().get(menuAction);
            if (action == null) {
                throw new IllegalArgumentException("Invalid action for menu item: " + menu);
            }
            menuItem.setAction(action);
            menuItem.setText(menuText);
            if (menudata.length > 2) {
                URL loc = this.getClass().getResource(menuIconsLocation + menudata[2]);
                if (loc == null) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unable to get icon at: " + menuIconsLocation + menudata[2]);
                } else {
                    ImageIcon i = new ImageIcon(loc);
                    menuItem.setIcon(i);
                }
            }
            if (stack == null) {
                this.popupMenu.get(editorPane).add(menuItem);
                continue;
            }
            ((JMenu)stack).add(menuItem);
        }
        editorPane.setComponentPopupMenu(this.popupMenu.get(editorPane));
    }

    @Override
    public ViewFactory getViewFactory() {
        return this;
    }

    @Override
    public View create(Element element) {
        return new SyntaxView(element, this.getConfig());
    }

    @Override
    public void install(JEditorPane editorPane) {
        super.install(editorPane);
        String fontName = this.getProperty("DefaultFont");
        Font f = DEFAULT_FONT;
        if (fontName != null) {
            f = Font.decode(fontName);
        }
        editorPane.setFont(f);
        Configuration conf = this.getConfig();
        Color caretColor = conf.getColor(CONFIG_CARETCOLOR, Color.BLACK);
        editorPane.setCaretColor(caretColor);
        Color selectionColor = this.getConfig().getColor(CONFIG_SELECTION, new Color(0x99CCFF));
        editorPane.setSelectionColor(selectionColor);
        this.addActions(editorPane);
        this.addComponents(editorPane);
        this.addPopupMenu(editorPane);
    }

    @Override
    public void deinstall(JEditorPane editorPane) {
        for (SyntaxComponent c : this.editorComponents.get(editorPane)) {
            c.deinstall(editorPane);
        }
        this.editorComponents.clear();
        editorPane.getActionMap().clear();
    }

    public void addActions(JEditorPane editorPane) {
        Keymap km_parent = JTextComponent.getKeymap("default");
        Keymap km_new = JTextComponent.addKeymap(PROPERTY_KEYMAP_JSYNTAXPANE, km_parent);
        for (Configuration.StringKeyMatcher m : this.getConfig().getKeys(ACTION_KEY_PATTERN)) {
            String[] values = Configuration.COMMA_SEPARATOR.split(m.value);
            String actionClass = values[0];
            String actionName = m.group1;
            SyntaxAction action = this.createAction(actionClass);
            action.config(this.getConfig(), "Action." + actionName);
            editorPane.getActionMap().put(actionName, action);
            for (int i = 1; i < values.length; ++i) {
                String keyStrokeString = values[i];
                KeyStroke ks = KeyStroke.getKeyStroke(keyStrokeString);
                if (ks == null) {
                    throw new IllegalArgumentException("Invalid KeyStroke: " + keyStrokeString);
                }
                km_new.addActionForKeyStroke(ks, action);
            }
        }
        editorPane.setKeymap(km_new);
    }

    private SyntaxAction createAction(String actionClassName) {
        SyntaxAction action = null;
        try {
            Class<?> clazz = Class.forName(actionClassName);
            action = (SyntaxAction)clazz.newInstance();
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException("Cannot create action class: " + actionClassName + ". Ensure it has default constructor.", ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("Cannot create action class: " + actionClassName, ex);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Cannot create action class: " + actionClassName, ex);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException("Cannot create action class: " + actionClassName, ex);
        }
        return action;
    }

    @Override
    public Document createDefaultDocument() {
        return new SyntaxDocument(this.lexer);
    }

    public static synchronized void initKit() {
        String defaultFont = DefaultSyntaxKit.getConfig(DefaultSyntaxKit.class).getString("DefaultFont");
        if (defaultFont != null) {
            DEFAULT_FONT = Font.decode(defaultFont);
        } else {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Object[] fonts = ge.getAvailableFontFamilyNames();
            Arrays.sort(fonts);
            if (Arrays.binarySearch(fonts, "Courier New") >= 0) {
                DEFAULT_FONT = new Font("Courier New", 0, 12);
            } else if (Arrays.binarySearch(fonts, "Courier") >= 0) {
                DEFAULT_FONT = new Font("Courier", 0, 12);
            } else if (Arrays.binarySearch(fonts, "Monospaced") >= 0) {
                DEFAULT_FONT = new Font("Monospaced", 0, 13);
            }
        }
        Properties kitsForTypes = JarServiceProvider.readProperties("jsyntaxpane/kitsfortypes");
        for (Map.Entry<Object, Object> e : kitsForTypes.entrySet()) {
            String classname = e.getValue().toString();
            String type = e.getKey().toString();
            DefaultSyntaxKit.registerContentType(type, classname);
        }
        initialized = true;
    }

    public static void registerContentType(String type, String classname) {
        try {
            Class<?> c = Class.forName(classname);
            Object kit = c.newInstance();
            if (!(kit instanceof EditorKit)) {
                throw new IllegalArgumentException("Cannot register class: " + classname + ". It does not extend EditorKit");
            }
            JEditorPane.registerEditorKitForContentType(type, classname);
            CONTENT_TYPES.add(type);
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException("Cannot register class: " + classname, ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("Cannot register class: " + classname, ex);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Cannot register class: " + classname, ex);
        }
        catch (RuntimeException ex) {
            throw new IllegalArgumentException("Cannot register class: " + classname, ex);
        }
    }

    public static String[] getContentTypes() {
        Object[] types = CONTENT_TYPES.toArray(new String[0]);
        Arrays.sort(types);
        return types;
    }

    public static void setConfig(Class<? extends DefaultSyntaxKit> kit, Map config) {
        DefaultSyntaxKit.getConfig(kit).putAll(config);
    }

    public static void setProperty(Class<? extends DefaultSyntaxKit> kit, String key, String value) {
        DefaultSyntaxKit.getConfig(kit).put(key, value);
    }

    public static String getProperty(Class<? extends DefaultSyntaxKit> kit, String key) {
        return DefaultSyntaxKit.getConfig(kit).getString(key);
    }

    public Configuration getConfig() {
        return DefaultSyntaxKit.getConfig(this.getClass());
    }

    public static synchronized Configuration getConfig(Class<? extends DefaultSyntaxKit> kit) {
        if (CONFIGS == null) {
            CONFIGS = new WeakHashMap<Class<? extends DefaultSyntaxKit>, Configuration>();
            Configuration defaultConfig = new Configuration(DefaultSyntaxKit.class);
            DefaultSyntaxKit.loadConfig(defaultConfig, DefaultSyntaxKit.class);
            CONFIGS.put(DefaultSyntaxKit.class, defaultConfig);
        }
        if (CONFIGS.containsKey(kit)) {
            return CONFIGS.get(kit);
        }
        Class<? extends DefaultSyntaxKit> superKit = kit.getSuperclass();
        Configuration defaults = CONFIGS.get(superKit);
        Configuration mine = new Configuration(kit, defaults);
        DefaultSyntaxKit.loadConfig(mine, kit);
        CONFIGS.put(kit, mine);
        return mine;
    }

    private static void loadConfig(Configuration conf, Class<? extends EditorKit> kit) {
        String url = kit.getName().replace(".", "/") + "/config";
        Properties p = JarServiceProvider.readProperties(url);
        if (p.size() == 0) {
            LOG.warning("unable to load configuration for: " + kit + " from: " + url);
        } else {
            conf.putAll((Map)p);
        }
    }

    public String getProperty(String string) {
        return this.getConfig().getString(string);
    }

    static {
        CONTENT_TYPES = new HashSet<String>();
        initialized = false;
        LOG = Logger.getLogger(DefaultSyntaxKit.class.getName());
        if (!initialized.booleanValue()) {
            DefaultSyntaxKit.initKit();
        }
    }
}

