CREATE OR REPLACE VIEW SVCO.V_OBJECT_VERSION
(
    SCHEMA,
    OBJECT,
    OBJECT_TYPE,
    VERSION_ID,
    DB_USER,
    OS_USER,
    MACHINE,
    DDL_TIME,
    IP_ADDRESS,
    MODULE,
    TAGS
)
AS
select t.schema
      ,t.name object
      ,t.obj_type object_type
      ,v.version_id
      ,v.dbuser db_user
      ,v.osuser os_user
      ,v.machine
      ,v.ddl_time
      ,v.ip_address
      ,v.module
      ,vcontrol_util.GetObjectTags(p_obj_id => t.obj_id, p_version_id => v.version_id)
  from t_object t, t_object_version v
 where t.obj_id = v.obj_id(+)
   and (vcontrol.Has_Admin_Role = 1 or
       upper(sys_context('USERENV', 'SESSION_USER')) = t.schema)
/
----------------------------------------------------
CREATE OR REPLACE VIEW SVCO.V_OBJECT_VERSION_TAG
(
    SCHEMA,
    OBJECT,
    OBJECT_TYPE,
    VERSION_ID,
    TAG
)
AS
select t.schema
      ,t.name object
      ,t.obj_type object_type
      ,v.version_id
      ,g.name tag
  from t_object t, t_object_version v, t_tag_to_object_version tov, t_tag g
 where t.obj_id = v.obj_id
   and v.obj_id = tov.obj_id
   and v.version_id = tov.version_id
   and tov.tag_id = g.tag_id
   and (vcontrol.Has_Admin_Role = 1 or
       upper(sys_context('USERENV', 'SESSION_USER')) = t.schema)
/
