CREATE TABLE SVCO.T_IGNORE_OBJECTS
(
    SCHEMA   VARCHAR2(30)  NOT NULL,
    OBJ_NAME VARCHAR2(255) NOT NULL,
    CONSTRAINT PK_IGNORE_OBJECTS
    PRIMARY KEY (SCHEMA,OBJ_NAME)
    VALIDATE
)
ORGANIZATION INDEX
TABLESPACE &idxtbs
/
----------------------------------------------------
CREATE TABLE SVCO.T_INCLUDE_OBJECTS
(
    SCHEMA   VARCHAR2(30)  NOT NULL,
    OBJ_NAME VARCHAR2(255) NOT NULL,
    CONSTRAINT PK_INCLUDE_OBJECTS
    PRIMARY KEY (SCHEMA,OBJ_NAME)
    VALIDATE
)
ORGANIZATION INDEX
TABLESPACE &idxtbs
/
----------------------------------------------------
CREATE TABLE SVCO.T_LICENSE_KEY
(
    LKEY  RAW(48) NOT NULL,
    LDATE DATE    NOT NULL
)
TABLESPACE &tabtbs
CACHE
/
----------------------------------------------------
CREATE TABLE SVCO.T_LOG
(
    LOG_ID        NUMBER                      NOT NULL,
    LOG_TIMESTAMP TIMESTAMP(6)                DEFAULT CURRENT_TIMESTAMP NOT NULL,
    LOG_TYP       CHAR(1)                     NOT NULL,
    MESSAGE       SVCO.DDL_CHANGE_MSG_TYP     NULL,
    ERROR         VARCHAR2(4000)              NULL
)
TABLESPACE &tabtbs
/
ALTER TABLE SVCO.T_LOG
    ADD CONSTRAINT T_LOG_PK
    PRIMARY KEY (LOG_ID)
    USING INDEX TABLESPACE &idxtbs
    ENABLE
/
----------------------------------------------------
CREATE TABLE SVCO.T_OBJECT
(
    OBJ_ID         NUMBER        NOT NULL,
    SCHEMA         VARCHAR2(30)  NOT NULL,
    NAME           VARCHAR2(255) NOT NULL,
    OBJ_TYPE       VARCHAR2(30)  NOT NULL,
    ORA_OBJ_ID     NUMBER            NULL,
    DEPENDS_OBJ_ID NUMBER            NULL
)
TABLESPACE &tabtbs
/
ALTER TABLE SVCO.T_OBJECT
    ADD CONSTRAINT T_OBJECT_PK
    PRIMARY KEY (OBJ_ID)
    USING INDEX TABLESPACE &idxtbs
    ENABLE
/
ALTER TABLE SVCO.T_OBJECT
    ADD CONSTRAINT T_OBJECT_UNQ_I
    UNIQUE (SCHEMA,NAME,OBJ_TYPE)
    USING INDEX TABLESPACE &idxtbs
    ENABLE
/
CREATE INDEX SVCO.T_OBJECT_DEPENDS_I
    ON SVCO.T_OBJECT(DEPENDS_OBJ_ID)
TABLESPACE &idxtbs
/
ALTER TABLE SVCO.T_OBJECT
    ADD CONSTRAINT T_OBJECT_DEPENDS
    FOREIGN KEY (DEPENDS_OBJ_ID)
    REFERENCES SVCO.T_OBJECT (OBJ_ID)
    ON DELETE CASCADE
    ENABLE
/
----------------------------------------------------
CREATE TABLE SVCO.T_OBJECT_DROPPED
(
    OBJ_ID         NUMBER        NOT NULL,
    SCHEMA         VARCHAR2(30)  NOT NULL,
    NAME           VARCHAR2(255) NOT NULL,
    OBJ_TYPE       VARCHAR2(30)  NOT NULL,
    ORA_OBJ_ID     NUMBER            NULL,
    DBUSER         VARCHAR2(30)      NULL,
    OSUSER         VARCHAR2(30)      NULL,
    MACHINE        VARCHAR2(64)      NULL,
    DROPPED_TIME   DATE          DEFAULT sysdate NOT NULL,
    IP_ADDRESS     VARCHAR2(30)      NULL,
    MODULE         VARCHAR2(48)      NULL,
    DEPENDS_OBJ_ID NUMBER            NULL
)
TABLESPACE &tabtbs
/
ALTER TABLE SVCO.T_OBJECT_DROPPED
    ADD CONSTRAINT T_OBJECT_DROPPED_PK
    PRIMARY KEY (OBJ_ID)
    USING INDEX TABLESPACE &idxtbs
    ENABLE
/
CREATE INDEX SVCO.T_OBJECT_DROPPED_DEPENDS_I
    ON SVCO.T_OBJECT_DROPPED(DEPENDS_OBJ_ID)
TABLESPACE &idxtbs
/
CREATE INDEX SVCO.T_OBJECT_DROPPED_I
    ON SVCO.T_OBJECT_DROPPED(SCHEMA,NAME,OBJ_TYPE)
TABLESPACE &idxtbs
/
----------------------------------------------------
CREATE TABLE SVCO.T_OBJECT_VERSION
(
    OBJ_ID     NUMBER       NOT NULL,
    VERSION_ID NUMBER       NOT NULL,
    SRC_CLOB   CLOB             NULL,
    SRC_BLOB   BLOB             NULL,
    SAVED_OPT  NUMBER(4)        NULL,
    DBUSER     VARCHAR2(30)     NULL,
    OSUSER     VARCHAR2(30)     NULL,
    MACHINE    VARCHAR2(64)     NULL,
    DDL_TIME   DATE         DEFAULT sysdate NOT NULL,
    IP_ADDRESS VARCHAR2(30)     NULL,
    MODULE     VARCHAR2(48)     NULL
)
TABLESPACE &tabtbs
/
ALTER TABLE SVCO.T_OBJECT_VERSION
    ADD CONSTRAINT T_OBJECT_VERSION_PK
    PRIMARY KEY (OBJ_ID,VERSION_ID)
    USING INDEX TABLESPACE &idxtbs
    ENABLE
/
ALTER TABLE SVCO.T_OBJECT_VERSION
    ADD CONSTRAINT T_OBJECT_VERSION_FK
    FOREIGN KEY (OBJ_ID)
    REFERENCES SVCO.T_OBJECT (OBJ_ID)
    ON DELETE CASCADE
    ENABLE
/
----------------------------------------------------
CREATE TABLE SVCO.T_OBJECT_VERSION_DROPPED
(
    OBJ_ID     NUMBER       NOT NULL,
    VERSION_ID NUMBER       NOT NULL,
    SRC_CLOB   CLOB             NULL,
    SRC_BLOB   BLOB             NULL,
    SAVED_OPT  NUMBER(4)        NULL,
    DBUSER     VARCHAR2(30)     NULL,
    OSUSER     VARCHAR2(30)     NULL,
    MACHINE    VARCHAR2(64)     NULL,
    DDL_TIME   DATE         DEFAULT sysdate NOT NULL,
    IP_ADDRESS VARCHAR2(30)     NULL,
    MODULE     VARCHAR2(48)     NULL
)
TABLESPACE &tabtbs
/
ALTER TABLE SVCO.T_OBJECT_VERSION_DROPPED
    ADD CONSTRAINT T_OBJECT_VERSION_DROPPED_PK
    PRIMARY KEY (OBJ_ID,VERSION_ID)
    USING INDEX TABLESPACE &idxtbs
    ENABLE
/
ALTER TABLE SVCO.T_OBJECT_VERSION_DROPPED
    ADD CONSTRAINT T_OBJECT_VERSION_DROPPED_FK
    FOREIGN KEY (OBJ_ID)
    REFERENCES SVCO.T_OBJECT_DROPPED (OBJ_ID)
    ON DELETE CASCADE
    ENABLE
/
----------------------------------------------------
CREATE TABLE SVCO.T_OPTIONS
(
    PROPERTY      VARCHAR2(30)  NOT NULL,
    VALUE         VARCHAR2(61)      NULL,
    DEFAULT_VALUE VARCHAR2(61)  NOT NULL,
    COMMENTS      VARCHAR2(512)     NULL
)
TABLESPACE &tabtbs
CACHE
/
COMMENT ON COLUMN SVCO.T_OPTIONS.PROPERTY IS
'Repository option name'
/
COMMENT ON COLUMN SVCO.T_OPTIONS.VALUE IS
'Repository option value'
/
COMMENT ON COLUMN SVCO.T_OPTIONS.DEFAULT_VALUE IS
'Repository option default value'
/
COMMENT ON COLUMN SVCO.T_OPTIONS.COMMENTS IS
'Repository option comments'
/
ALTER TABLE SVCO.T_OPTIONS
    ADD CONSTRAINT T_OPTIONS_PK
    PRIMARY KEY (PROPERTY)
    USING INDEX TABLESPACE &idxtbs
    ENABLE
/
----------------------------------------------------
CREATE TABLE SVCO.T_SUPPORTED_OBJECTS
(
    OBJECT_TYPE VARCHAR2(30) NOT NULL,
    META_TYPE   VARCHAR2(30)     NULL,
    ENABLED     NUMBER(1)    DEFAULT 1 NOT NULL,
    ATTR        VARCHAR2(4)  NOT NULL
)
TABLESPACE &tabtbs
CACHE
/
COMMENT ON COLUMN SVCO.T_SUPPORTED_OBJECTS.ENABLED IS
'1 - Object type is enabled'
/
COMMENT ON COLUMN SVCO.T_SUPPORTED_OBJECTS.ATTR IS
'''N'' represents a named object, ''D'' represents a dependent object, ''S'' represents a schema object, ''L'' represents a logical dependent object'
/
ALTER TABLE SVCO.T_SUPPORTED_OBJECTS
    ADD CONSTRAINT T_SUPPORTED_OBJECTS_PK
    PRIMARY KEY (OBJECT_TYPE)
    USING INDEX TABLESPACE &idxtbs
    ENABLE
/
----------------------------------------------------
CREATE GLOBAL TEMPORARY TABLE SVCO.T_PLUGIN_DATA
(
    ID   NUMBER NOT NULL,
    DATA CLOB   NOT NULL
) ON COMMIT PRESERVE ROWS
/
ALTER TABLE SVCO.T_PLUGIN_DATA
    ADD CONSTRAINT PK_T_PLUGIN_DATA
    PRIMARY KEY (ID)
    ENABLE
    VALIDATE
/
