set feedback off
set define off
prompt Loading T_OPTIONS...
insert into SVCO.T_OPTIONS (PROPERTY, VALUE, DEFAULT_VALUE, COMMENTS)
values ('DEBUG', null, 'FALSE', 'for internal use');
insert into SVCO.T_OPTIONS (PROPERTY, VALUE, DEFAULT_VALUE, COMMENTS)
values ('COMPRESS', null, 'TRUE', 'If TRUE, compress all objects data in the repository to save disk space');
insert into SVCO.T_OPTIONS (PROPERTY, VALUE, DEFAULT_VALUE, COMMENTS)
values ('ENCRYPT', null, 'FALSE', 'If TRUE, encrypt all objects data in the repository');
insert into SVCO.T_OPTIONS (PROPERTY, VALUE, DEFAULT_VALUE, COMMENTS)
values ('SYSTEM_GENERATED', null, 'FALSE', 'If TRUE, select indexes or triggers even if they are system-generated. If FALSE, omit system-generated indexes or triggers. Defaults to FALSE');
insert into SVCO.T_OPTIONS (PROPERTY, VALUE, DEFAULT_VALUE, COMMENTS)
values ('COMPRESS_QUALITY', null, '6', 'Speed versus efficiency of resulting compressed output. Valid values are the range 1..9, with a default value of 6. 1=fastest compression, 9=slowest compression and best compressed size');
insert into SVCO.T_OPTIONS (PROPERTY, VALUE, DEFAULT_VALUE, COMMENTS)
values ('INDEX_SEGMENT_ATTRIBUTES', null, 'TRUE', 'If TRUE, emit segment attributes (physical attributes, storage attributes, tablespace, logging');
insert into SVCO.T_OPTIONS (PROPERTY, VALUE, DEFAULT_VALUE, COMMENTS)
values ('INDEX_STORAGE', null, 'TRUE', 'If TRUE, emit storage clause. (Ignored if INDEX_SEGMENT_ATTRIBUTES is FALSE.)');
insert into SVCO.T_OPTIONS (PROPERTY, VALUE, DEFAULT_VALUE, COMMENTS)
values ('INDEX_TABLESPACE', null, 'TRUE', 'If TRUE, emit tablespace. (Ignored if INDEX_SEGMENT_ATTRIBUTES is FALSE.)');
insert into SVCO.T_OPTIONS (PROPERTY, VALUE, DEFAULT_VALUE, COMMENTS)
values ('TYPE_OID', null, 'FALSE', 'If TRUE, emit the OID clause');
insert into SVCO.T_OPTIONS (PROPERTY, VALUE, DEFAULT_VALUE, COMMENTS)
values ('VIEW_FORCE', null, 'TRUE', 'If TRUE, use the FORCE keyword in the CREATE VIEW statement');
insert into SVCO.T_OPTIONS (PROPERTY, VALUE, DEFAULT_VALUE, COMMENTS)
values ('SEQ_IGNORE_NEXTVAL', null, 'TRUE', 'if TRUE, ignore last sequence value (NEXTVAL)');
insert into SVCO.T_OPTIONS (PROPERTY, VALUE, DEFAULT_VALUE, COMMENTS)
values ('TABLE_SEGMENT_ATTRIBUTES', null, 'TRUE', 'If TRUE, emit segment attributes (physical attributes, storage attributes, tablespace, logging');
insert into SVCO.T_OPTIONS (PROPERTY, VALUE, DEFAULT_VALUE, COMMENTS)
values ('TABLE_STORAGE', null, 'TRUE', 'If TRUE, emit storage clause. (Ignored if TABLE_SEGMENT_ATTRIBUTES is FALSE.)');
insert into SVCO.T_OPTIONS (PROPERTY, VALUE, DEFAULT_VALUE, COMMENTS)
values ('TABLE_CONSTRAINTS', null, 'TRUE', 'If TRUE, emit all non-referential table constraints');
insert into SVCO.T_OPTIONS (PROPERTY, VALUE, DEFAULT_VALUE, COMMENTS)
values ('TABLE_REF_CONSTRAINTS', null, 'TRUE', 'If TRUE, emit all referential constraints (foreign keys)');
insert into SVCO.T_OPTIONS (PROPERTY, VALUE, DEFAULT_VALUE, COMMENTS)
values ('TABLE_OID', null, 'FALSE', 'If TRUE, emit the OID clause for object tables');
insert into SVCO.T_OPTIONS (PROPERTY, VALUE, DEFAULT_VALUE, COMMENTS)
values ('TABLE_TABLESPACE', null, 'TRUE', 'If TRUE, emit tablespace. (Ignored if TABLE_SEGMENT_ATTRIBUTES is FALSE.)');
insert into SVCO.T_OPTIONS (PROPERTY, VALUE, DEFAULT_VALUE, COMMENTS)
values ('VALID', null, 'FALSE', 'If TRUE, proceed only with objects in STATUS=VALID and objects without STATUS');
commit;
prompt Loading T_SUPPORTED_OBJECTS...
insert into SVCO.T_SUPPORTED_OBJECTS (OBJECT_TYPE, META_TYPE, ENABLED, ATTR)
values ('LIBRARY', null, 1, 'SN');
insert into SVCO.T_SUPPORTED_OBJECTS (OBJECT_TYPE, META_TYPE, ENABLED, ATTR)
values ('TYPE BODY', 'TYPE_BODY', 1, 'SNL');
insert into SVCO.T_SUPPORTED_OBJECTS (OBJECT_TYPE, META_TYPE, ENABLED, ATTR)
values ('DB_LINK', null, 1, 'SN');
insert into SVCO.T_SUPPORTED_OBJECTS (OBJECT_TYPE, META_TYPE, ENABLED, ATTR)
values ('CLUSTER', null, 1, 'SN');
insert into SVCO.T_SUPPORTED_OBJECTS (OBJECT_TYPE, META_TYPE, ENABLED, ATTR)
values ('TABLE', null, 1, 'SN');
insert into SVCO.T_SUPPORTED_OBJECTS (OBJECT_TYPE, META_TYPE, ENABLED, ATTR)
values ('TRIGGER', null, 1, 'SND');
insert into SVCO.T_SUPPORTED_OBJECTS (OBJECT_TYPE, META_TYPE, ENABLED, ATTR)
values ('INDEX', null, 1, 'SND');
insert into SVCO.T_SUPPORTED_OBJECTS (OBJECT_TYPE, META_TYPE, ENABLED, ATTR)
values ('INDEXTYPE', null, 1, 'SN');
insert into SVCO.T_SUPPORTED_OBJECTS (OBJECT_TYPE, META_TYPE, ENABLED, ATTR)
values ('FUNCTION', null, 1, 'SN');
insert into SVCO.T_SUPPORTED_OBJECTS (OBJECT_TYPE, META_TYPE, ENABLED, ATTR)
values ('PROCEDURE', null, 1, 'SN');
insert into SVCO.T_SUPPORTED_OBJECTS (OBJECT_TYPE, META_TYPE, ENABLED, ATTR)
values ('VIEW', null, 1, 'SN');
insert into SVCO.T_SUPPORTED_OBJECTS (OBJECT_TYPE, META_TYPE, ENABLED, ATTR)
values ('MATERIALIZED VIEW', 'MATERIALIZED_VIEW', 1, 'SN');
insert into SVCO.T_SUPPORTED_OBJECTS (OBJECT_TYPE, META_TYPE, ENABLED, ATTR)
values ('MATERIALIZED_VIEW_LOG', null, 1, 'D');
insert into SVCO.T_SUPPORTED_OBJECTS (OBJECT_TYPE, META_TYPE, ENABLED, ATTR)
values ('SEQUENCE', null, 1, 'SN');
insert into SVCO.T_SUPPORTED_OBJECTS (OBJECT_TYPE, META_TYPE, ENABLED, ATTR)
values ('SYNONYM', null, 1, 'SN');
insert into SVCO.T_SUPPORTED_OBJECTS (OBJECT_TYPE, META_TYPE, ENABLED, ATTR)
values ('PACKAGE', 'PACKAGE_SPEC', 1, 'SN');
insert into SVCO.T_SUPPORTED_OBJECTS (OBJECT_TYPE, META_TYPE, ENABLED, ATTR)
values ('PACKAGE BODY', 'PACKAGE_BODY', 1, 'SNL');
insert into SVCO.T_SUPPORTED_OBJECTS (OBJECT_TYPE, META_TYPE, ENABLED, ATTR)
values ('COMMENT', null, 1, 'D');
insert into SVCO.T_SUPPORTED_OBJECTS (OBJECT_TYPE, META_TYPE, ENABLED, ATTR)
values ('OBJECT PRIVILEGE', 'OBJECT_GRANT', 1, 'D');
insert into SVCO.T_SUPPORTED_OBJECTS (OBJECT_TYPE, META_TYPE, ENABLED, ATTR)
values ('TYPE', 'TYPE_SPEC', 1, 'SN');
commit;
set feedback on
set define on
